/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.genbase.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Application;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.FileArchive;
import org.ow2.jonas.generators.genbase.utils.TempRepository;
import org.ow2.jonas.generators.genbase.utils.XMLUtils;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;

public class DummyApplication
extends Application {
    private String name;

    public DummyApplication(String name) throws GenBaseException {
        super(DummyApplication.createFileArchive(), null);
        this.name = name;
        this.init();
    }

    private static Archive createFileArchive() throws GenBaseException {
        TempRepository tr = TempRepository.getInstance();
        try {
            File tmp = tr.createDir();
            File meta = new File(tmp, "META-INF");
            meta.mkdirs();
            File manifest = new File(meta, "MANIFEST.MF");
            Manifest mf = new Manifest();
            mf.getMainAttributes().putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            FileOutputStream os = new FileOutputStream(manifest);
            mf.write(os);
            os.flush();
            ((OutputStream)os).close();
            File application = new File(meta, "application.xml");
            InputStream is = DummyApplication.class.getResourceAsStream("application.xml");
            if (is == null) {
                throw new GenBaseException("Cannot load 'application.xml' template.");
            }
            FileUtils.dump((InputStream)is, (File)application);
            is.close();
            return new FileArchive(tmp);
        }
        catch (IOException ioe) {
            throw new GenBaseException(ioe);
        }
        catch (FileUtilsException fue) {
            throw new GenBaseException((Exception)((Object)fue));
        }
    }

    @Override
    protected void init() throws GenBaseException {
        this.setEjbjars(new Vector());
        this.setWebapps(new Vector());
        this.setClients(new Vector());
        this.loadDescriptors();
        XMLUtils.cleanDummyApplication(this.getApp());
    }

    @Override
    public String getName() {
        return this.name;
    }
}

