/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.shelbie.commands.ssh.server.internal;

import java.security.Provider;
import java.security.Security;
import java.util.Set;
import jline.console.completer.Completer;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.apache.felix.ipojo.annotations.Component;
import org.apache.felix.ipojo.annotations.Invalidate;
import org.apache.felix.ipojo.annotations.Property;
import org.apache.felix.ipojo.annotations.Requires;
import org.apache.felix.ipojo.annotations.Validate;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.server.jaas.JaasPasswordAuthenticator;
import org.ow2.shelbie.commands.ssh.server.ISshDaemon;
import org.ow2.shelbie.commands.ssh.server.internal.CommandFactoryImpl;
import org.ow2.shelbie.commands.ssh.server.internal.HostKey;
import org.ow2.shelbie.commands.ssh.server.internal.KeyPairProviderFactory;
import org.ow2.shelbie.commands.ssh.server.internal.PasswordFinderSetter;
import org.ow2.shelbie.commands.ssh.server.internal.PublickeyAuthenticatorImpl;
import org.ow2.shelbie.commands.ssh.server.internal.ShellFactoryImpl;
import org.ow2.shelbie.core.IPromptProvider;

@Component
public class SshDaemonComponent
implements ISshDaemon,
Pojo {
    private InstanceManager __IM;
    private boolean __Fserver;
    private SshServer server;
    private boolean __Fprovider;
    @Requires
    private CommandProcessor provider;
    private boolean __Fcompleter;
    @Requires(filter="(type=commands)")
    private Completer completer;
    private boolean __FpromptProvider;
    @Requires(policy="dynamic-priority")
    private IPromptProvider promptProvider;
    private boolean __Fport;
    @Property(mandatory=true, name="sshd.port")
    private int port;
    private boolean __Fpassphrase;
    @Property
    private String passphrase;
    private boolean __Mstart;
    private boolean __Mstop;

    SshServer __getserver() {
        if (!this.__Fserver) {
            return this.server;
        }
        return (SshServer)this.__IM.onGet((Object)this, "server");
    }

    void __setserver(SshServer sshServer) {
        if (!this.__Fserver) {
            this.server = sshServer;
            return;
        }
        this.__IM.onSet((Object)this, "server", (Object)sshServer);
    }

    CommandProcessor __getprovider() {
        if (!this.__Fprovider) {
            return this.provider;
        }
        return (CommandProcessor)this.__IM.onGet((Object)this, "provider");
    }

    void __setprovider(CommandProcessor commandProcessor) {
        if (!this.__Fprovider) {
            this.provider = commandProcessor;
            return;
        }
        this.__IM.onSet((Object)this, "provider", (Object)commandProcessor);
    }

    Completer __getcompleter() {
        if (!this.__Fcompleter) {
            return this.completer;
        }
        return (Completer)this.__IM.onGet((Object)this, "completer");
    }

    void __setcompleter(Completer completer) {
        if (!this.__Fcompleter) {
            this.completer = completer;
            return;
        }
        this.__IM.onSet((Object)this, "completer", (Object)completer);
    }

    IPromptProvider __getpromptProvider() {
        if (!this.__FpromptProvider) {
            return this.promptProvider;
        }
        return (IPromptProvider)this.__IM.onGet((Object)this, "promptProvider");
    }

    void __setpromptProvider(IPromptProvider iPromptProvider) {
        if (!this.__FpromptProvider) {
            this.promptProvider = iPromptProvider;
            return;
        }
        this.__IM.onSet((Object)this, "promptProvider", (Object)iPromptProvider);
    }

    int __getport() {
        if (!this.__Fport) {
            return this.port;
        }
        Object object = this.__IM.onGet((Object)this, "port");
        Integer n = (Integer)object;
        return n;
    }

    void __setport(int n) {
        if (!this.__Fport) {
            this.port = n;
            return;
        }
        Integer n2 = new Integer(n);
        this.__IM.onSet((Object)this, "port", (Object)n2);
    }

    String __getpassphrase() {
        if (!this.__Fpassphrase) {
            return this.passphrase;
        }
        return (String)this.__IM.onGet((Object)this, "passphrase");
    }

    void __setpassphrase(String string) {
        if (!this.__Fpassphrase) {
            this.passphrase = string;
            return;
        }
        this.__IM.onSet((Object)this, "passphrase", (Object)string);
    }

    public SshDaemonComponent() {
        this(null);
    }

    private SshDaemonComponent(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public void start() throws Exception {
        if (!this.__Mstart) {
            this.__M_start();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "start", new Object[0]);
            this.__M_start();
            this.__IM.onExit((Object)this, "start", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "start", throwable);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Validate
    private void __M_start() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        ClassLoader newCL = SshDaemonComponent.class.getClassLoader();
        Thread.currentThread().setContextClassLoader(newCL);
        try {
            boolean bcProv = true;
            try {
                Security.addProvider((Provider)newCL.loadClass("org.bouncycastle.jce.provider.BouncyCastleProvider").newInstance());
            }
            catch (ClassNotFoundException cnfe) {
                bcProv = false;
            }
            HostKey hostKey = HostKey.findHostKey();
            KeyPairProviderFactory keyPairProviderFactory = new KeyPairProviderFactory(hostKey);
            KeyPairProvider keyPairProvider = keyPairProviderFactory.get();
            if (bcProv && this.__getpassphrase() != null) {
                PasswordFinderSetter passwordFinderSetter = (PasswordFinderSetter)newCL.loadClass("org.ow2.shelbie.commands.ssh.server.internal.SimplePasswordFinder").getConstructor(String.class).newInstance(this.__getpassphrase());
                passwordFinderSetter.setPasswordFinder(keyPairProvider);
            }
            this.__setserver(SshServer.setUpDefaultServer());
            this.__getserver().setPort(this.__getport());
            this.__getserver().setShellFactory(new ShellFactoryImpl(this.__getprovider(), this.__getcompleter(), this.__getpromptProvider()));
            this.__getserver().setCommandFactory(new CommandFactoryImpl(this.__getprovider()));
            this.__getserver().setKeyPairProvider(keyPairProvider);
            if (hostKey.getDsaKey() != null || hostKey.getRsaKey() != null || hostKey.getObjKey() != null) {
                this.__getserver().setPublickeyAuthenticator(new PublickeyAuthenticatorImpl(keyPairProvider, hostKey));
            }
            JaasPasswordAuthenticator pswdAuth = new JaasPasswordAuthenticator();
            pswdAuth.setDomain("shelbie");
            this.__getserver().setPasswordAuthenticator(pswdAuth);
            this.__getserver().start();
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public void stop() throws Exception {
        if (!this.__Mstop) {
            this.__M_stop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "stop", new Object[0]);
            this.__M_stop();
            this.__IM.onExit((Object)this, "stop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "stop", throwable);
            throw throwable;
        }
    }

    @Invalidate
    private void __M_stop() throws Exception {
        this.__getserver().stop();
        this.__setserver(null);
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("completer")) {
                this.__Fcompleter = true;
            }
            if (set.contains("passphrase")) {
                this.__Fpassphrase = true;
            }
            if (set.contains("port")) {
                this.__Fport = true;
            }
            if (set.contains("promptProvider")) {
                this.__FpromptProvider = true;
            }
            if (set.contains("provider")) {
                this.__Fprovider = true;
            }
            if (set.contains("server")) {
                this.__Fserver = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("start")) {
                this.__Mstart = true;
            }
            if (set.contains("stop")) {
                this.__Mstop = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

