/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.wsdl;

import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.extensions.schema.SchemaReference;
import javax.xml.namespace.QName;
import org.apache.cxf.frontend.WSDLGetUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.message.Message;
import org.ow2.jonas.ws.cxf.jaxws.CXFWSEndpoint;
import org.ow2.jonas.ws.cxf.jaxws.WebservicesContainer;
import org.ow2.jonas.ws.jaxws.PortIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsdlUpdater
extends WSDLGetUtils {
    private WebservicesContainer<? extends CXFWSEndpoint> container;

    public WsdlUpdater(WebservicesContainer<? extends CXFWSEndpoint> container) {
        this.container = container;
    }

    protected void updateDoc(Document doc, String base, Map<String, Definition> mp, Map<String, SchemaReference> smp, Message message) {
        super.updateDoc(doc, base, mp, smp, message);
        QName serviceQName = message.getExchange().getService().getName();
        List serviceList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"service");
        for (Element serviceEl : serviceList) {
            String serviceName = serviceEl.getAttribute("name");
            if (!serviceName.equals(serviceQName.getLocalPart())) continue;
            List elementList = DOMUtils.findAllElementsByTagNameNS((Element)doc.getDocumentElement(), (String)"http://schemas.xmlsoap.org/wsdl/", (String)"port");
            for (Element el : elementList) {
                String name = el.getAttribute("name");
                String url = this.container.findUpdatedURL(new PortIdentifier(serviceQName, name));
                if (url == null) continue;
                this.rewriteAddress(url, el, "http://schemas.xmlsoap.org/wsdl/soap/");
                this.rewriteAddress(url, el, "http://schemas.xmlsoap.org/wsdl/soap12/");
            }
        }
    }
}

