/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.Util;

public class JOnASCompilationUnit
implements ICompilationUnit {
    private String className;
    private String sourceFile;
    private List<CompilerError> errors;
    private char[] cachedContent = null;
    private CompilationContext context;

    public JOnASCompilationUnit(String className, String sourceFile, CompilationContext context, List<CompilerError> errors) {
        this.className = className;
        this.sourceFile = sourceFile;
        this.context = context;
        this.errors = errors;
    }

    @Override
    public char[] getContents() {
        if (this.cachedContent == null) {
            try {
                this.cachedContent = Util.toCharArray(new FileInputStream(new File(this.sourceFile)), this.context.getEncoding());
            }
            catch (FileNotFoundException e) {
                this.errors.add(new CompilerError(this.className, e));
                return null;
            }
        }
        return this.cachedContent;
    }

    @Override
    public char[] getMainTypeName() {
        int dot = this.className.lastIndexOf(46);
        if (dot > 0) {
            return this.className.substring(dot + 1).toCharArray();
        }
        return this.className.toCharArray();
    }

    @Override
    public char[][] getPackageName() {
        String[] parts = this.className.split("\\.");
        char[][] result = new char[parts.length - 1][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = parts[i].toCharArray();
        }
        return null;
    }

    @Override
    public char[] getFileName() {
        return this.sourceFile.toCharArray();
    }
}

