/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.eclipse.compiler;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.ow2.jonas.eclipse.compiler.CompilationContext;
import org.ow2.jonas.eclipse.compiler.CompilerError;
import org.ow2.jonas.eclipse.compiler.JOnASCompilationUnit;
import org.ow2.jonas.eclipse.compiler.JOnASCompilerRequestor;
import org.ow2.jonas.eclipse.compiler.JOnASNameEnvironment;
import org.ow2.jonas.eclipse.compiler.Util;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASCompiler {
    private static final Log log = LogFactory.getLog(JOnASCompiler.class);
    private CompilationContext context;

    public JOnASCompiler(CompilationContext context) {
        this.context = context;
        if (context.getContextualClassLoader() == null) {
            context.setContextualClassLoader(Thread.currentThread().getContextClassLoader());
        }
    }

    public List<CompilerError> compile() {
        ArrayList<JOnASCompilationUnit> compilationUnits = new ArrayList<JOnASCompilationUnit>();
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        for (String source : this.context.getSources()) {
            JOnASCompilationUnit unit = new JOnASCompilationUnit(Util.getClassName(source), new File(this.context.getSourceDirectory(), source).getAbsolutePath(), this.context, errors);
            compilationUnits.add(unit);
        }
        Compiler compiler = new Compiler((INameEnvironment)new JOnASNameEnvironment(this.context, errors), DefaultErrorHandlingPolicies.proceedWithAllProblems(), this.context.getCompilerOptions(), (ICompilerRequestor)new JOnASCompilerRequestor(this.context.getOutputDirectory(), errors), (IProblemFactory)new DefaultProblemFactory(Locale.getDefault()));
        log.debug((Object)"Compiling {0} units into {1} using {2} CLassLoader.", new Object[]{compilationUnits.size(), this.context.getOutputDirectory(), this.context.getContextualClassLoader()});
        ICompilationUnit[] units = compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]);
        compiler.compile(units);
        return errors;
    }
}

