/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.QueueingProcessor;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkQueue;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.MasterJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.SlaveJGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jms.JMSBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.batchindexing.Executors;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

public class BatchedQueueingProcessor
implements QueueingProcessor {
    private static final Logger log = LoggerFactory.make();
    private final boolean sync;
    private final int batchSize;
    private final ExecutorService executorService;
    private final BackendQueueProcessorFactory backendQueueProcessorFactory;

    public BatchedQueueingProcessor(WorkerBuildContext context, Properties properties) {
        this.sync = BatchedQueueingProcessor.isConfiguredAsSync(properties);
        int threadPoolSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.thread_pool.size", 1);
        int queueSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.buffer_queue.max", Integer.MAX_VALUE);
        this.batchSize = ConfigurationParseHelper.getIntValue(properties, "hibernate.search.worker.batch_size", 0);
        this.executorService = !this.sync ? Executors.newFixedThreadPool(threadPoolSize, "backend queueing processor", queueSize) : null;
        String backend = properties.getProperty("hibernate.search.worker.backend");
        this.backendQueueProcessorFactory = StringHelper.isEmpty(backend) || "lucene".equalsIgnoreCase(backend) ? new LuceneBackendQueueProcessorFactory() : ("jms".equalsIgnoreCase(backend) ? new JMSBackendQueueProcessorFactory() : ("blackhole".equalsIgnoreCase(backend) ? new BlackHoleBackendQueueProcessorFactory() : ("jgroupsMaster".equals(backend) ? new MasterJGroupsBackendQueueProcessorFactory() : ("jgroupsSlave".equals(backend) ? new SlaveJGroupsBackendQueueProcessorFactory() : ClassLoaderHelper.instanceFromName(BackendQueueProcessorFactory.class, backend, BatchedQueueingProcessor.class, "processor")))));
        this.backendQueueProcessorFactory.initialize(properties, context);
        context.setBackendQueueProcessorFactory(this.backendQueueProcessorFactory);
    }

    public void add(Work work, WorkQueue workQueue) {
        workQueue.add(work);
        if (this.batchSize > 0 && workQueue.size() >= this.batchSize) {
            WorkQueue subQueue = workQueue.splitQueue();
            this.prepareWorks(subQueue);
            this.performWorks(subQueue);
        }
    }

    public void prepareWorks(WorkQueue workQueue) {
        workQueue.prepareWorkPlan();
    }

    public void performWorks(WorkQueue workQueue) {
        List<LuceneWork> sealedQueue = workQueue.getSealedQueue();
        if (log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("Lucene WorkQueue to send to backend:[ \n\t");
            for (LuceneWork lw : sealedQueue) {
                sb.append(lw.toString());
                sb.append("\n\t");
            }
            if (sealedQueue.size() > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
            log.trace(sb.toString());
        }
        Runnable processor = this.backendQueueProcessorFactory.getProcessor(sealedQueue);
        if (this.sync) {
            processor.run();
        } else {
            this.executorService.execute(processor);
        }
    }

    public void cancelWorks(WorkQueue workQueue) {
        workQueue.clear();
    }

    public void close() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
            try {
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error("Unable to properly shut down asynchronous indexing work", (Throwable)e);
            }
        }
        this.backendQueueProcessorFactory.close();
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("hibernate.search.worker.execution"));
    }
}

