/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.util.List;
import java.util.Properties;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessorFactory;
import org.hibernate.search.backend.impl.jgroups.JGroupsMasterMessageListener;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessorFactory;
import org.hibernate.search.spi.WorkerBuildContext;
import org.jgroups.Receiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterJGroupsBackendQueueProcessorFactory
extends JGroupsBackendQueueProcessorFactory {
    private LuceneBackendQueueProcessorFactory luceneBackendQueueProcessorFactory;
    private Receiver masterListener;

    @Override
    public void initialize(Properties props, WorkerBuildContext context) {
        super.initialize(props, context);
        this.initLuceneBackendQueueProcessorFactory(props, context);
        this.registerMasterListener();
    }

    @Override
    public Runnable getProcessor(List<LuceneWork> queue) {
        return this.luceneBackendQueueProcessorFactory.getProcessor(queue);
    }

    private void registerMasterListener() {
        this.masterListener = new JGroupsMasterMessageListener(this.searchFactory);
        this.channel.setReceiver(this.masterListener);
    }

    private void initLuceneBackendQueueProcessorFactory(Properties props, WorkerBuildContext context) {
        this.luceneBackendQueueProcessorFactory = new LuceneBackendQueueProcessorFactory();
        this.luceneBackendQueueProcessorFactory.initialize(props, context);
    }

    public Receiver getMasterListener() {
        return this.masterListener;
    }

    @Override
    public void close() {
        super.close();
        this.luceneBackendQueueProcessorFactory.close();
    }
}

