/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.BinaryStream;
import org.hibernate.type.descriptor.java.BinaryStreamImpl;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataHelper {
    private static final Logger log = LoggerFactory.getLogger(DataHelper.class);
    private static Class nClobClass;

    public static boolean isNClob(Class type) {
        return nClobClass != null && nClobClass.isAssignableFrom(type);
    }

    public static String extractString(Reader reader) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = reader.read(buffer, 0, buffer.length)) != -1) {
                stringBuilder.append(buffer, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading text", ioe);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.warn("IOException occurred closing stream", (Throwable)e);
            }
        }
        return stringBuilder.toString();
    }

    private static String extractString(Reader characterStream, long start, int length) {
        StringBuilder stringBuilder = new StringBuilder(length);
        try {
            int amountRead;
            long skipped = characterStream.skip(start);
            if (skipped != start) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            char[] buffer = new char[2048];
            int charsRead = 0;
            while ((amountRead = characterStream.read(buffer, 0, buffer.length)) != -1) {
                stringBuilder.append(buffer, 0, amountRead);
                if (amountRead >= buffer.length && (charsRead += amountRead) < length) continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading a binary value", ioe);
        }
        return stringBuilder.toString();
    }

    public static Object subStream(Reader characterStream, long start, int length) {
        return new StringReader(DataHelper.extractString(characterStream, start, length));
    }

    public static byte[] extractBytes(InputStream inputStream) {
        if (BinaryStream.class.isInstance(inputStream)) {
            return ((BinaryStream)((Object)inputStream)).getBytes();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(2048);
        try {
            int amountRead;
            byte[] buffer = new byte[2048];
            while ((amountRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading a binary value", ioe);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                log.warn("IOException occurred closing input stream", (Throwable)e);
            }
            try {
                outputStream.close();
            }
            catch (IOException e) {
                log.warn("IOException occurred closing output stream", (Throwable)e);
            }
        }
        return outputStream.toByteArray();
    }

    public static byte[] extractBytes(InputStream inputStream, long start, int length) {
        if (BinaryStream.class.isInstance(inputStream) && Integer.MAX_VALUE > start) {
            byte[] data = ((BinaryStream)((Object)inputStream)).getBytes();
            int size = Math.min(length, data.length);
            byte[] result = new byte[size];
            System.arraycopy(data, (int)start, result, 0, size);
            return result;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(length);
        try {
            int amountRead;
            long skipped = inputStream.skip(start);
            if (skipped != start) {
                throw new HibernateException("Unable to skip needed bytes");
            }
            byte[] buffer = new byte[2048];
            int bytesRead = 0;
            while ((amountRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, amountRead);
                if (amountRead >= buffer.length && (bytesRead += amountRead) < length) continue;
                break;
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading a binary value", ioe);
        }
        return outputStream.toByteArray();
    }

    public static InputStream subStream(InputStream inputStream, long start, int length) {
        return new BinaryStreamImpl(DataHelper.extractBytes(inputStream, start, length));
    }

    static {
        try {
            nClobClass = ReflectHelper.classForName("java.sql.NClob", DataHelper.class);
        }
        catch (ClassNotFoundException e) {
            log.info("Could not locate 'java.sql.NClob' class; assuming JDBC 3");
        }
    }
}

