/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Vector;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;
import org.jacorb.slf4j.Logger;

public abstract class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private final Current current;
    private Vector pool;
    private Vector activeProcessors;
    private int unused_size;
    private final int max_pool_size;
    private final int min_pool_size;
    private boolean inUse = false;
    private final Configuration configuration;
    private final Logger logger;

    protected RPPoolManager(Current current, int n, int n2, Logger logger, Configuration configuration) {
        this.current = current;
        this.max_pool_size = n2;
        this.min_pool_size = n;
        this.logger = logger;
        this.configuration = configuration;
    }

    private void addProcessor() {
        RequestProcessor requestProcessor = new RequestProcessor(this);
        try {
            requestProcessor.configure(this.configuration);
        }
        catch (ConfigurationException configurationException) {
            throw new RuntimeException(configurationException.toString());
        }
        this.current._addContext(requestProcessor, requestProcessor);
        requestProcessor.setDaemon(true);
        this.pool.addElement(requestProcessor);
        ++this.unused_size;
        requestProcessor.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.add(this.pmListener, rPPoolManagerListener);
    }

    abstract void destroy();

    protected synchronized void destroy(boolean bl) {
        if (this.pool == null || !this.inUse) {
            return;
        }
        while (!this.activeProcessors.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Object[] objectArray = new RequestProcessor[this.pool.size()];
        this.pool.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            if (((RequestProcessor)objectArray[i]).isActive()) {
                throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
            }
            this.pool.removeElement(objectArray[i]);
            --this.unused_size;
            this.current._removeContext((Thread)objectArray[i]);
            ((RequestProcessor)objectArray[i]).end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool == null ? 0 : this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.unused_size;
    }

    protected synchronized RequestProcessor getProcessor() {
        if (!this.inUse) {
            this.init();
            this.inUse = true;
        }
        if (this.pool.isEmpty() && this.unused_size < this.max_pool_size) {
            this.addProcessor();
        }
        while (this.pool.isEmpty()) {
            this.warnPoolIsEmpty();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        RequestProcessor requestProcessor = (RequestProcessor)this.pool.remove(this.pool.size() - 1);
        this.activeProcessors.add(requestProcessor);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(requestProcessor, this.pool.size(), this.unused_size);
        }
        return requestProcessor;
    }

    protected void warnPoolIsEmpty() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Thread pool exhausted, consider increasing jacorb.poa.thread_pool_max (currently: " + this.max_pool_size + ")");
        }
    }

    private void init() {
        this.pool = new Vector(this.max_pool_size);
        this.activeProcessors = new Vector(this.max_pool_size);
        for (int i = 0; i < this.min_pool_size; ++i) {
            this.addProcessor();
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor requestProcessor) {
        this.activeProcessors.remove(requestProcessor);
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addElement(requestProcessor);
        } else {
            --this.unused_size;
            this.current._removeContext(requestProcessor);
            requestProcessor.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(requestProcessor, this.pool.size(), this.unused_size);
        }
        this.notifyAll();
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener rPPoolManagerListener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, rPPoolManagerListener);
    }
}

