/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.logical;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.BaseClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.ClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.logical.LogicalClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;

public class LogicalCluster
extends BaseCluster
implements BaseClusterMBean {
    protected String type = "LogicalCluster";

    public LogicalCluster(ClusterFactory cf) throws JMException {
        super(cf);
    }

    @Override
    public ClusterMember createClusterMember(String svname, ServerProxy proxy) {
        return new LogicalClusterMember(svname, proxy);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean addServer(String serverName, ServerProxy proxy) {
        LogicalClusterMember server = new LogicalClusterMember(serverName, proxy);
        boolean added = this.addMember(server);
        if (added) {
            ObjectName on = null;
            try {
                on = JonasObjectName.clusterMember((String)this.domainName, (String)serverName, (String)this.getType(), (String)this.name);
                server.setObjectName(on);
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(on)) {
                    mbeanServer.unregisterMBean(on);
                }
                mbeanServer.registerMBean(server, on);
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot register " + on + ": " + e));
            }
        }
        return added;
    }

    @Override
    public synchronized void removeServer(String svname) {
        String domainName;
        ClusterMember member = (ClusterMember)this.members.remove(svname);
        if (member != null && (domainName = member.getProxy().getDomain()).equals(this.name)) {
            ServerProxy sp = member.getProxy();
            ObjectName spOn = null;
            try {
                spOn = ObjectName.getInstance(sp.getObjectName());
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(spOn)) {
                    mbeanServer.unregisterMBean(spOn);
                }
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot unregister ServerProxy of " + svname + ": " + e));
            }
        }
    }
}

