/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.domain.cluster.tomcat;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.management.domain.cluster.BaseCluster;
import org.ow2.jonas.lib.management.domain.cluster.ClusterMember;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatClusterFactory;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatClusterMBean;
import org.ow2.jonas.lib.management.domain.cluster.tomcat.TomcatClusterMember;
import org.ow2.jonas.lib.management.domain.proxy.server.ServerProxy;
import org.ow2.jonas.lib.util.JonasObjectName;

public class TomcatCluster
extends BaseCluster
implements TomcatClusterMBean {
    private String host = null;
    protected String type = "TomcatCluster";
    private String mcastAddr = null;
    private long mcastDropTime;
    private long mcastFrequency;
    private int mcastPort;
    private int mcastSocketTimeout;

    public TomcatCluster(TomcatClusterFactory cf) throws JMException {
        super(cf);
    }

    @Override
    public ClusterMember createClusterMember(String svname, ServerProxy proxy) {
        logger.log(BasicLevel.WARN, (Object)("Cannot correctly create tomcat cluster member " + svname));
        return new TomcatClusterMember(svname, this.host, proxy);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public boolean addTomcatServer(String serverName, ServerProxy proxy) {
        String domainName = proxy.getDomain();
        TomcatClusterMember tomcat = new TomcatClusterMember(serverName, this.host, proxy);
        tomcat.setInfo();
        boolean added = this.addMember(tomcat);
        if (added) {
            try {
                ObjectName on = JonasObjectName.clusterMember((String)domainName, (String)serverName, (String)this.getType(), (String)this.name);
                tomcat.setObjectName(on);
                MBeanServer mbeanServer = this.jmx.getJmxServer();
                if (mbeanServer.isRegistered(on)) {
                    mbeanServer.unregisterMBean(on);
                }
                mbeanServer.registerMBean(tomcat, on);
            }
            catch (JMException e) {
                logger.log(BasicLevel.WARN, (Object)("Cannot register tomcat " + serverName + ": " + e));
            }
        }
        return added;
    }

    @Override
    public String getMcastAddr() {
        return this.mcastAddr;
    }

    @Override
    public long getMcastDropTime() {
        return this.mcastDropTime;
    }

    @Override
    public long getMcastFrequency() {
        return this.mcastFrequency;
    }

    @Override
    public int getMcastPort() {
        return this.mcastPort;
    }

    @Override
    public int getMcastSocketTimeout() {
        return this.mcastSocketTimeout;
    }

    public void setMcastAddr(String mcastAddr) {
        this.mcastAddr = mcastAddr;
    }

    public void setMcastDropTime(long mcastDropTime) {
        this.mcastDropTime = mcastDropTime;
    }

    public void setMcastFrequency(long mcastFrequency) {
        this.mcastFrequency = mcastFrequency;
    }

    public void setMcastPort(int mcastPort) {
        this.mcastPort = mcastPort;
    }

    public void setMcastSocketTimeout(int mcastSocketTimeout) {
        this.mcastSocketTimeout = mcastSocketTimeout;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }
}

