/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Resource;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractInjectionHandler;

public class HandlerResourceProcessor
extends AbstractInjectionHandler {
    private Map<String, String> params;

    public HandlerResourceProcessor(Map<String, String> params) {
        this.params = params;
    }

    public boolean isSupported(Class<? extends Annotation> aClass) {
        return Resource.class.equals(aClass);
    }

    public void process(Annotation annotation, Method method, Object o) throws ProcessorException {
        Resource resource = (Resource)annotation;
        String name = resource.name();
        if (name == null || "".equals(name)) {
            name = this.getAttributeName(method);
        }
        String value = this.params.get(name);
        if (method.getParameterTypes().length == 1) {
            Class<?> type = method.getParameterTypes()[0];
            Object injectableValue = this.convertValue(value, type);
            this.doInjectMethod(method, o, injectableValue);
        }
    }

    private Object convertValue(String value, Class<?> type) {
        Object ret = null;
        if (String.class.isAssignableFrom(type)) {
            ret = value;
        } else if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            ret = Integer.valueOf(value);
        } else if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            ret = Double.valueOf(value);
        } else if (Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            ret = Character.valueOf(value.charAt(0));
        } else if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            ret = Long.valueOf(value);
        } else if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            ret = Float.valueOf(value);
        } else if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            ret = Byte.valueOf(value);
        } else if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            ret = Short.valueOf(value);
        } else if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            ret = Boolean.valueOf(value);
        }
        return ret;
    }

    public void process(Annotation annotation, Field field, Object o) throws ProcessorException {
        Resource resource = (Resource)annotation;
        String name = resource.name();
        if (name == null || "".equals(name)) {
            name = field.getName();
        }
        String value = this.params.get(name);
        Class<?> type = field.getType();
        Object injectableValue = this.convertValue(value, type);
        this.doInjectField(field, o, injectableValue);
    }
}

