/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.Context;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceContext;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.annotation.processor.handler.AbstractJNDIInjectionHandler;

public class InstanceProcessor
extends AbstractJNDIInjectionHandler {
    public InstanceProcessor(Context envContext) {
        super(envContext);
    }

    public boolean isSupported(Class<? extends Annotation> aClass) {
        return Resource.class.equals(aClass) || EJB.class.equals(aClass) || PersistenceUnit.class.equals(aClass) || PersistenceContext.class.equals(aClass);
    }

    public void process(Annotation annotation, Field field, Object target) throws ProcessorException {
        if (WebServiceContext.class.equals(field.getType())) {
            return;
        }
        String name = this.getNameFromAnnotation(annotation);
        if (name == null || "".equals(name)) {
            name = this.getStandardBindingName(field);
        }
        Object value = this.doContextLookup(name);
        this.doInjectField(field, target, value);
    }

    public void process(Annotation annotation, Method method, Object target) throws ProcessorException {
        if (method.getParameterTypes().length == 1 && WebServiceContext.class.equals(method.getParameterTypes()[0])) {
            return;
        }
        String name = this.getNameFromAnnotation(annotation);
        if (name == null || "".equals(name)) {
            name = this.getStandardBindingName(method);
        }
        Object value = this.doContextLookup(name);
        this.doInjectMethod(method, target, value);
    }

    private String getNameFromAnnotation(Annotation annotation) {
        String name = null;
        if (annotation instanceof Resource) {
            name = ((Resource)annotation).name();
        } else if (annotation instanceof EJB) {
            name = ((EJB)annotation).name();
        } else if (annotation instanceof PersistenceUnit) {
            name = ((PersistenceUnit)annotation).name();
        } else if (annotation instanceof PersistenceContext) {
            name = ((PersistenceContext)annotation).name();
        }
        return name;
    }
}

