/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.bean.EasyBeansSB;
import org.ow2.easybeans.api.bean.EasyBeansSLSB;
import org.ow2.easybeans.api.bean.info.IBeanInfo;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.container.AbsFactory;
import org.ow2.easybeans.container.info.SessionBeanInfo;
import org.ow2.easybeans.container.session.EasyBeansSessionContext;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.proxy.client.ClientRPCInvocationHandler;
import org.ow2.easybeans.rpc.EJBLocalRequestImpl;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBRemoteRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.easybeans.rpc.util.Hash;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.basic.CreatePoolItemException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionFactory<PoolType extends EasyBeansSB<PoolType>>
extends AbsFactory<PoolType> {
    private static final boolean RECREATE_DYNAMIC_PROXY = Boolean.getBoolean("easybeans.recreate.dynamic.proxy");
    protected static final int TRIES_CREATION = 10;
    private static Log logger = LogFactory.getLog(SessionFactory.class);
    private SessionBeanInfo sessionBeanInfo = null;
    private InheritableThreadLocal<String> invokedBusinessInterfaceNameThreadLocal = new InheritableThreadLocal();
    private AtomicInteger creationFails = new AtomicInteger(0);

    public SessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        try {
            this.getPool().stop();
        }
        catch (PoolException e) {
            logger.error((Object)"Problem when stopping the factory", new Object[]{e});
        }
        finally {
            super.stop();
        }
    }

    public IBeanInfo getBeanInfo() {
        return this.sessionBeanInfo;
    }

    public SessionBeanInfo getSessionBeanInfo() {
        return this.sessionBeanInfo;
    }

    public void setSessionBeanInfo(SessionBeanInfo sessionBeanInfo) {
        this.sessionBeanInfo = sessionBeanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolType createPoolItem() throws CreatePoolItemException {
        int fails = this.creationFails.get();
        Long waitTime = WAITING_TIME_BEFORE_CREATION;
        if (fails > 10) {
            waitTime = null;
        }
        EasyBeansSB instance = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                instance = (EasyBeansSB)this.getBeanClass().newInstance();
            }
            catch (InstantiationException e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot create a new instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot create a new instance", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot create a new instance", (Throwable)e);
            }
            catch (Exception e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot create a new instance", (Throwable)e);
            }
            catch (Error e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to create a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot create a new instance", (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        instance.setEasyBeansFactory((Factory)this);
        instance.setEasyBeansInvocationContextFactory(this.getInvocationContextFactory());
        EasyBeansSessionContext<SessionFactory> sessionContext = new EasyBeansSessionContext<SessionFactory>(this);
        instance.setEasyBeansContext(sessionContext);
        oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            try {
                this.injectResources(instance);
            }
            catch (PoolException e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to perform injection of resources in the instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot perform injection of resources in the instance of the class '" + this.getBeanClass().getName() + "'.", (Throwable)e);
            }
            catch (RuntimeException e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to perform injection of resources in the instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot perform injection of resources in the instance of the class '" + this.getBeanClass().getName() + "'.", (Throwable)e);
            }
            catch (Exception e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to perform injection of resources in the instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot perform injection of resources in the instance of the class '" + this.getBeanClass().getName() + "'.", (Throwable)e);
            }
            catch (Error e) {
                this.creationFails.incrementAndGet();
                logger.error((Object)"Unable to perform injection of resources in the instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
                throw new CreatePoolItemException(waitTime, "Cannot perform injection of resources in the instance of the class '" + this.getBeanClass().getName() + "'.", (Throwable)e);
            }
            this.postConstruct(instance);
        }
        catch (RuntimeException e) {
            this.creationFails.incrementAndGet();
            logger.error((Object)"Unable to perform postconstruct on a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
            throw new CreatePoolItemException(waitTime, "Cannot perform postConstruct on the new instance", (Throwable)e);
        }
        catch (Exception e) {
            this.creationFails.incrementAndGet();
            logger.error((Object)"Unable to perform postconstruct on a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
            throw new CreatePoolItemException(waitTime, "Cannot perform postConstruct on the new instance", (Throwable)e);
        }
        catch (Error e) {
            this.creationFails.incrementAndGet();
            logger.error((Object)"Unable to perform postconstruct on a new instance of the class ''{0}''", new Object[]{this.getBeanClass().getName(), e});
            throw new CreatePoolItemException(waitTime, "Cannot perform postConstruct on the new instance", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        this.creationFails.set(0);
        return (PoolType)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EJBResponse rpcInvoke(EJBRemoteRequest request) {
        Method calledMethod = this.getHashes().get(request.getMethodHash());
        if (calledMethod == null) {
            logger.debug((Object)"Requested method {0} is not present on the bean class ''{1}''", new Object[]{request.getMethodName(), this.getBeanClass()});
            return new JEJBResponse();
        }
        Object[] args = null;
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            args = request.getMethodArgs();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        IAuditID previousID = null;
        if (this.getCurrentInvocationID() != null) {
            previousID = this.getCurrentInvocationID().newInvocation();
        }
        String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(calledMethod) + "@Remote";
        Object event = this.getInvocationEventBegin(methodEventProviderId, args);
        long number = event.getInvocationNumber();
        this.getEventDispatcher().dispatch((IEvent)event);
        try {
            Object value;
            EJBLocalRequestImpl localRequest = new EJBLocalRequestImpl(request.getMethodHash(), args, request.getBeanId(), request.getInvokedBusinessInterfaceName());
            localRequest.setCalledFromRemoteRequest(true);
            EJBResponse result = this.localCall(localRequest);
            event = new EventBeanInvocationEnd(methodEventProviderId, number, result);
            if (RECREATE_DYNAMIC_PROXY && (value = result.getValue()) != null) {
                try {
                    InvocationHandler handler = Proxy.getInvocationHandler(value);
                    if (handler instanceof ClientRPCInvocationHandler && ((ClientRPCInvocationHandler)handler).isBusinessObjectMode()) {
                        result.setValue((Object)handler);
                        EJBResponse eJBResponse = result;
                        return eJBResponse;
                    }
                }
                catch (IllegalArgumentException e) {
                    logger.debug((Object)"Not a proxy instance", new Object[]{e});
                }
            }
            EJBResponse eJBResponse = result;
            return eJBResponse;
        }
        catch (Exception ex) {
            event = new EventBeanInvocationError(methodEventProviderId, number, ex);
            throw new RuntimeException(ex);
        }
        finally {
            if (this.getCurrentInvocationID() != null) {
                this.getCurrentInvocationID().setAuditID(previousID);
            }
            this.getEventDispatcher().dispatch((IEvent)event);
        }
    }

    protected abstract PoolType getBean(Long var1) throws IllegalArgumentException;

    public abstract EJBResponse localCall(EJBLocalRequest var1);

    protected InheritableThreadLocal<String> getInvokedBusinessInterfaceNameThreadLocal() {
        return this.invokedBusinessInterfaceNameThreadLocal;
    }

    public void poolItemRemoved(PoolType instance) {
        super.remove(instance);
        instance.setEasyBeansRemoved(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTimeout(Timer timer, IMethodInfo methodInfo) {
        if (!this.isStarted()) {
            logger.warn((Object)"Received a timer call but the factory has been stopped, so ignore this call", new Object[0]);
            return;
        }
        if (methodInfo != null) {
            long hashMethod = Hash.hashMethod(methodInfo.getName(), methodInfo.getDescriptor());
            Object[] parameters = null;
            if (methodInfo.getParameters().size() == 1) {
                parameters = new Object[]{timer};
            }
            if (methodInfo != null) {
                EJBLocalRequestImpl request = new EJBLocalRequestImpl(hashMethod, parameters, 0L, TimerService.class.getName());
                EJBResponse response = this.localCall(request);
                RPCException exception = response.getRPCException();
                if (exception != null) {
                    logger.error((Object)"Unable to call the timer callback", new Object[]{exception});
                }
                return;
            }
        }
        PoolType bean = this.getBean(null);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
        try {
            bean.timeoutCallByEasyBeans(timer);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            if (bean.getClass().isAssignableFrom(EasyBeansSLSB.class)) {
                try {
                    this.getPool().release(bean);
                }
                catch (PoolException e) {
                    throw new EJBException("cannot release bean", (Exception)((Object)e));
                }
            }
        }
    }
}

