/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.singleton;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.ejb.NoSuchEJBException;
import javax.ejb.Timer;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.FactoryException;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSingletonSB;
import org.ow2.easybeans.api.bean.info.IAccessTimeoutInfo;
import org.ow2.easybeans.api.bean.info.IApplicationExceptionInfo;
import org.ow2.easybeans.api.bean.info.ILockTypeInfo;
import org.ow2.easybeans.api.bean.info.IMethodInfo;
import org.ow2.easybeans.api.event.bean.EZBEventBeanInvocationBegin;
import org.ow2.easybeans.container.session.JPoolWrapperFactory;
import org.ow2.easybeans.container.session.PoolWrapper;
import org.ow2.easybeans.container.session.SessionFactory;
import org.ow2.easybeans.container.session.stateful.ConcurrentBuilderException;
import org.ow2.easybeans.event.bean.EventBeanInvocationEnd;
import org.ow2.easybeans.event.bean.EventBeanInvocationError;
import org.ow2.easybeans.naming.J2EEManagedObjectNamingHelper;
import org.ow2.easybeans.rpc.JEJBResponse;
import org.ow2.easybeans.rpc.api.EJBLocalRequest;
import org.ow2.easybeans.rpc.api.EJBResponse;
import org.ow2.easybeans.rpc.api.RPCException;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.api.IPoolConfiguration;
import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.JPool;
import org.ow2.util.pool.impl.enhanced.EnhancedPool;
import org.ow2.util.pool.impl.enhanced.PoolConfiguration;
import org.ow2.util.pool.impl.enhanced.manager.IPoolManager;
import org.ow2.util.pool.impl.enhanced.manager.optional.IPoolItemRemoveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonSessionFactory
extends SessionFactory<EasyBeansSingletonSB>
implements IPoolItemRemoveManager<EasyBeansSingletonSB> {
    private static final Log LOGGER = LogFactory.getLog(SingletonSessionFactory.class);
    private ReadWriteLock lock = null;
    private volatile EasyBeansSingletonSB singletonBean = null;

    public SingletonSessionFactory(String className, EZBContainer container) throws FactoryException {
        super(className, container);
        PoolConfiguration poolConfig = new PoolConfiguration();
        poolConfig.setMax(1);
        poolConfig.setMin(1);
        poolConfig.setSpare(0);
        if (Boolean.getBoolean("easybeans.useSimplePool")) {
            JPool jPool = new JPool(new JPoolWrapperFactory(this));
            jPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(jPool);
        } else {
            EnhancedPool singletonPool = this.getManagementPool().getEnhancedPoolFactory().createEnhancedPool((IPoolManager)this);
            singletonPool.setPoolConfiguration((IPoolConfiguration)poolConfig);
            this.setPool(new PoolWrapper(singletonPool));
        }
        this.lock = new ReentrantReadWriteLock();
    }

    @Override
    protected EasyBeansSingletonSB getBean(Long beanId) throws IllegalArgumentException {
        if (this.singletonBean != null) {
            return this.singletonBean;
        }
        try {
            return (EasyBeansSingletonSB)this.getPool().get();
        }
        catch (PoolException e) {
            throw new IllegalArgumentException("Cannot get element in the pool", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EJBResponse localCall(EJBLocalRequest localCallRequest) {
        boolean getAccess;
        Lock lock;
        IAccessTimeoutInfo accessTimeout;
        Long methodHash;
        JEJBResponse ejbResponse;
        block38: {
            block37: {
                ejbResponse = new JEJBResponse();
                methodHash = localCallRequest.getMethodHash();
                IMethodInfo methodInfo = this.getMethodInfoHashes().get(methodHash);
                accessTimeout = null;
                ILockTypeInfo methodLockType = null;
                if (methodInfo != null) {
                    accessTimeout = methodInfo.getAccessTimeout();
                    methodLockType = methodInfo.getLockType();
                }
                lock = null;
                lock = ILockTypeInfo.READ == methodLockType ? this.lock.readLock() : this.lock.writeLock();
                getAccess = true;
                if (accessTimeout == null) break block37;
                if (accessTimeout.value() == -1L) {
                    lock.lock();
                    break block38;
                } else if (accessTimeout.value() >= 0L) {
                    try {
                        LOGGER.debug((Object)"Trying to lock bean with value ''{0}'' and timeunit ''{1}''", new Object[]{accessTimeout.value(), accessTimeout.unit()});
                        getAccess = lock.tryLock(accessTimeout.value(), accessTimeout.unit());
                    }
                    catch (InterruptedException e) {
                        ejbResponse.setRPCException(new RPCException("Cannot get a lock for the stateful instance", (Throwable)e));
                        return ejbResponse;
                    }
                }
                break block38;
            }
            lock.lock();
        }
        if (!getAccess && accessTimeout != null) {
            RPCException rpcException = null;
            rpcException = accessTimeout.value() == 0L ? new RPCException((Throwable)ConcurrentBuilderException.buildConcurrentException("Unable to get a concurrent access on bean '" + this.getClassName() + "' and method '" + this.getHashes().get(methodHash) + "'.")) : new RPCException((Throwable)ConcurrentBuilderException.buildConcurrentTimeoutException("Unable to get a concurrent access with an accessTimeout of '" + accessTimeout + "' on bean '" + this.getClassName() + "' and method '" + this.getHashes().get(methodHash) + "'."));
            ejbResponse.setRPCException(rpcException);
            return ejbResponse;
        }
        try {
            Object value;
            block35: {
                OperationState oldState;
                String oldInvokedBusinessInterface;
                ClassLoader oldClassLoader;
                block36: {
                    Method m;
                    if (this.singletonBean == null) {
                        try {
                            this.singletonBean = this.getBean(null);
                        }
                        catch (IllegalArgumentException e) {
                            ejbResponse.setRPCException(new RPCException("Cannot get element in the pool", (Throwable)e));
                            JEJBResponse jEJBResponse = ejbResponse;
                            Object var27_18 = null;
                            lock.unlock();
                            return jEJBResponse;
                        }
                        catch (NoSuchEJBException e) {
                            ejbResponse.setRPCException(new RPCException("Bean has been removed", (Throwable)e));
                            JEJBResponse jEJBResponse = ejbResponse;
                            Object var27_19 = null;
                            lock.unlock();
                            return jEJBResponse;
                        }
                    }
                    if ((m = this.getHashes().get(methodHash)) == null) {
                        ejbResponse.setRPCException(new RPCException("Cannot find method called on the bean '" + this.getClassName() + "'."));
                        JEJBResponse jEJBResponse = ejbResponse;
                        Object var27_20 = null;
                        lock.unlock();
                        return jEJBResponse;
                    }
                    value = null;
                    oldClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(this.getContainer().getClassLoader());
                    oldInvokedBusinessInterface = (String)this.getInvokedBusinessInterfaceNameThreadLocal().get();
                    this.getInvokedBusinessInterfaceNameThreadLocal().set(localCallRequest.getInvokedBusinessInterfaceName());
                    oldState = this.getOperationState();
                    this.getOperationStateThreadLocal().set(OperationState.BUSINESS_METHOD);
                    String methodEventProviderId = this.getJ2EEManagedObjectId() + "/" + J2EEManagedObjectNamingHelper.getMethodSignature(m) + "@Local";
                    boolean enabledEvent = !localCallRequest.isCalledFromRemoteRequest();
                    EZBEventBeanInvocationBegin event = null;
                    long number = 0L;
                    IAuditID previousID = null;
                    if (enabledEvent) {
                        if (this.getCurrentInvocationID() != null) {
                            previousID = this.getCurrentInvocationID().newInvocation();
                        }
                        event = this.getInvocationEventBegin(methodEventProviderId, localCallRequest.getMethodArgs());
                        number = event.getInvocationNumber();
                        this.getEventDispatcher().dispatch((IEvent)event);
                    }
                    try {
                        try {
                            value = m.invoke((Object)this.singletonBean, localCallRequest.getMethodArgs());
                        }
                        catch (IllegalArgumentException e) {
                            ejbResponse.setRPCException(new RPCException((Throwable)e));
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                            }
                            Object var25_32 = null;
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                if (this.getCurrentInvocationID() != null) {
                                    this.getCurrentInvocationID().setAuditID(previousID);
                                }
                            }
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                            this.getOperationStateThreadLocal().set(oldState);
                            break block35;
                        }
                        catch (IllegalAccessException e) {
                            ejbResponse.setRPCException(new RPCException((Throwable)e));
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                            }
                            Object var25_33 = null;
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                if (this.getCurrentInvocationID() != null) {
                                    this.getCurrentInvocationID().setAuditID(previousID);
                                }
                            }
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                            this.getOperationStateThreadLocal().set(oldState);
                            break block35;
                        }
                        catch (InvocationTargetException e) {
                            Throwable cause = e.getCause();
                            RPCException rpcException = new RPCException(cause);
                            IApplicationExceptionInfo applicationException = this.getBeanInfo().getApplicationException(cause);
                            if (applicationException != null) {
                                rpcException.setApplicationException();
                            }
                            ejbResponse.setRPCException(rpcException);
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationError(methodEventProviderId, number, e));
                            }
                            Object var25_34 = null;
                            if (enabledEvent) {
                                this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                                if (this.getCurrentInvocationID() != null) {
                                    this.getCurrentInvocationID().setAuditID(previousID);
                                }
                            }
                            Thread.currentThread().setContextClassLoader(oldClassLoader);
                            this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                            this.getOperationStateThreadLocal().set(oldState);
                            break block35;
                        }
                        Object var25_31 = null;
                        if (!enabledEvent) break block36;
                    }
                    catch (Throwable throwable) {
                        Object var25_35 = null;
                        if (enabledEvent) {
                            this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                            if (this.getCurrentInvocationID() != null) {
                                this.getCurrentInvocationID().setAuditID(previousID);
                            }
                        }
                        Thread.currentThread().setContextClassLoader(oldClassLoader);
                        this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                        this.getOperationStateThreadLocal().set(oldState);
                        throw throwable;
                    }
                    this.getEventDispatcher().dispatch((IEvent)new EventBeanInvocationEnd(methodEventProviderId, number, value));
                    if (this.getCurrentInvocationID() != null) {
                        this.getCurrentInvocationID().setAuditID(previousID);
                    }
                }
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.getInvokedBusinessInterfaceNameThreadLocal().set(oldInvokedBusinessInterface);
                this.getOperationStateThreadLocal().set(oldState);
            }
            ejbResponse.setValue(value);
        }
        catch (Throwable throwable) {
            Object var27_22 = null;
            lock.unlock();
            throw throwable;
        }
        Object var27_21 = null;
        lock.unlock();
        return ejbResponse;
    }

    @Override
    public void start() throws FactoryException {
        super.start();
        if ((this.getSessionBeanInfo().isStartup() || this.getSessionBeanInfo().getTimersInfo().size() > 0) && this.singletonBean == null) {
            try {
                this.singletonBean = this.getBean(null);
            }
            catch (RuntimeException e) {
                throw new FactoryException("Cannot initialize Singleton bean", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        block7: {
            try {
                Collection timers = this.getTimerService().getTimers();
                for (Timer timer : timers) {
                    timer.cancel();
                }
                Object var5_4 = null;
                if (this.singletonBean == null) break block7;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.singletonBean != null) {
                    try {
                        this.getPool().release((Object)this.singletonBean);
                    }
                    catch (PoolException e) {
                        LOGGER.error((Object)"Unable to release singleton bean", new Object[]{e});
                    }
                }
                super.stop();
                throw throwable;
            }
            try {
                this.getPool().release((Object)this.singletonBean);
                break block7;
            }
            catch (PoolException e) {
                LOGGER.error((Object)"Unable to release singleton bean", new Object[]{e});
            }
            {
            }
        }
        super.stop();
    }
}

