/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.container.session.stateful;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.ejb.EJBException;

public class ConcurrentBuilderException {
    private static ConcurrentBuilderException unique = null;
    private Class<?> concurrentTimeoutExceptionClass = null;
    private Constructor<?> concurrentTimeoutExceptionConstructor = null;
    private Class<?> concurrentExceptionClass = null;
    private Constructor<?> concurrentExceptionConstructor = null;

    public ConcurrentBuilderException() {
        try {
            this.concurrentExceptionClass = ConcurrentBuilderException.class.getClassLoader().loadClass("javax.ejb.ConcurrentAccessException");
        }
        catch (ClassNotFoundException e) {
            this.concurrentExceptionClass = EJBException.class;
        }
        try {
            this.concurrentExceptionConstructor = this.concurrentExceptionClass.getConstructor(String.class);
        }
        catch (SecurityException e) {
            throw new EJBException("Unable to get constructor", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new EJBException("Unable to get constructor", (Exception)e);
        }
        try {
            this.concurrentTimeoutExceptionClass = ConcurrentBuilderException.class.getClassLoader().loadClass("javax.ejb.ConcurrentAccessTimeoutException");
        }
        catch (ClassNotFoundException e) {
            this.concurrentTimeoutExceptionClass = EJBException.class;
        }
        try {
            this.concurrentTimeoutExceptionConstructor = this.concurrentTimeoutExceptionClass.getConstructor(String.class);
        }
        catch (SecurityException e) {
            throw new EJBException("Unable to get constructor", (Exception)e);
        }
        catch (NoSuchMethodException e) {
            throw new EJBException("Unable to get constructor", (Exception)e);
        }
    }

    public EJBException concurrentTimeoutException(String message) {
        try {
            return (EJBException)this.concurrentTimeoutExceptionConstructor.newInstance(message);
        }
        catch (InstantiationException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
    }

    public EJBException concurrentException(String message) {
        try {
            return (EJBException)this.concurrentExceptionConstructor.newInstance(message);
        }
        catch (InstantiationException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (IllegalAccessException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (IllegalArgumentException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
        catch (InvocationTargetException e) {
            throw new EJBException("Unable to build instance", (Exception)e);
        }
    }

    public static EJBException buildConcurrentTimeoutException(String message) {
        return ConcurrentBuilderException.getInstance().concurrentTimeoutException(message);
    }

    public static EJBException buildConcurrentException(String message) {
        return ConcurrentBuilderException.getInstance().concurrentException(message);
    }

    protected static ConcurrentBuilderException getInstance() {
        if (unique == null) {
            unique = new ConcurrentBuilderException();
        }
        return unique;
    }
}

