/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.checks;

import org.ow2.easybeans.deployment.annotations.exceptions.InterceptorsValidationException;
import org.ow2.easybeans.deployment.annotations.helper.bean.checks.AccessChecker;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.enhancer.bean.BeanClassAdapter;

public final class TimerBeanValidator {
    private TimerBeanValidator() {
    }

    public static void validate(EasyBeansEjbJarClassMetadata bean) {
        EasyBeansEjbJarMethodMetadata alreadyFoundTimerMethod = null;
        for (EasyBeansEjbJarMethodMetadata method : bean.getMethodMetadataCollection()) {
            if (!method.isTimeout()) continue;
            if (alreadyFoundTimerMethod != null) {
                throw new InterceptorsValidationException("A bean cannot have more than one timer method, previous timer method is '" + alreadyFoundTimerMethod + "' while the new one is '" + method + "'.");
            }
            alreadyFoundTimerMethod = method;
            if (!BeanClassAdapter.TIMER_JMETHOD.getDescriptor().equals(method.getJMethod().getDescriptor()) && !BeanClassAdapter.TIMER_JMETHOD_NOARG.getDescriptor().equals(method.getJMethod().getDescriptor())) {
                throw new InterceptorsValidationException("The timeout method '" + method + "' hasn't a valid signature. The valid signature should be '" + BeanClassAdapter.TIMER_JMETHOD.getDescriptor() + "'.");
            }
            AccessChecker.ensureNoAccess(16, method.getJMethod(), "Final", bean.getClassName());
            AccessChecker.ensureNoAccess(8, method.getJMethod(), "Static", bean.getClassName());
        }
    }
}

