/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.deployment.annotations.helper.bean.session;

import org.ow2.easybeans.deployment.annotations.helper.ResolverHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class SessionSynchronizationResolver {
    private static final String SESSION_SYNCHRONIZATION_INTERFACE = "javax/ejb/SessionSynchronization";
    private static final JMethod AFTER_BEGIN_METHOD = new JMethod(1, "afterBegin", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});
    private static final JMethod BEFORE_COMPLETION_METHOD = new JMethod(1, "beforeCompletion", "()V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});
    private static final JMethod AFTER_COMPLETION_METHOD = new JMethod(1, "afterCompletion", "(Z)V", null, new String[]{"javax/ejb/EJBException", "java/rmi/RemoteException"});

    private SessionSynchronizationResolver() {
    }

    public static void resolve(EasyBeansEjbJarClassMetadata statefulSessionBean) {
        if (!statefulSessionBean.isStateful()) {
            return;
        }
        boolean implementsSessionSynchronization = false;
        String[] interfaces = statefulSessionBean.getInterfaces();
        if (interfaces != null) {
            for (String itf : interfaces) {
                if (!SESSION_SYNCHRONIZATION_INTERFACE.equals(itf)) continue;
                implementsSessionSynchronization = true;
                break;
            }
        }
        if (implementsSessionSynchronization) {
            EasyBeansEjbJarMethodMetadata afterBeginMethod = ResolverHelper.getMethod(statefulSessionBean, AFTER_BEGIN_METHOD, true, SESSION_SYNCHRONIZATION_INTERFACE);
            afterBeginMethod.setAfterBegin();
            EasyBeansEjbJarMethodMetadata beforeCompletionMethod = ResolverHelper.getMethod(statefulSessionBean, BEFORE_COMPLETION_METHOD, true, SESSION_SYNCHRONIZATION_INTERFACE);
            beforeCompletionMethod.setBeforeCompletion();
            EasyBeansEjbJarMethodMetadata afterCompletionMethod = ResolverHelper.getMethod(statefulSessionBean, AFTER_COMPLETION_METHOD, true, SESSION_SYNCHRONIZATION_INTERFACE);
            afterCompletionMethod.setAfterCompletion();
        }
    }
}

