/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.ejbinwar;

import java.util.Map;
import javax.naming.Context;
import org.ow2.easybeans.container.JContainerConfig;
import org.ow2.easybeans.deployment.EasyBeansDeployableInfo;
import org.ow2.easybeans.ejbinwar.EJBInWarArchive;
import org.ow2.easybeans.resolver.api.EZBApplicationJNDIResolver;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployableInfo;
import org.ow2.util.ee.deploy.api.deployable.WARDeployable;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansEJBWarBuilder {
    private static final Log LOGGER = LogFactory.getLog(EasyBeansEJBWarBuilder.class);
    private IDeployableHelper deployableHelper = null;

    public EJB3Deployable getEJBFromWarDeployable(WARDeployable warDeployable, Map<?, ?> properties) {
        EJBInWarArchive ejbInWarArchive;
        IArchive warArchive = warDeployable.getArchive();
        try {
            ejbInWarArchive = new EJBInWarArchive(warArchive);
        }
        catch (ArchiveException e) {
            throw new IllegalStateException("Cannot build archive", e);
        }
        EJB3Deployable ejb3Deployable = this.getEJB3(ejbInWarArchive);
        if (ejb3Deployable == null) {
            return null;
        }
        ClassLoader classLoader = (ClassLoader)properties.get(ClassLoader.class);
        EZBApplicationJNDIResolver applicationJNDIResolver = (EZBApplicationJNDIResolver)properties.get(EZBApplicationJNDIResolver.class);
        String moduleName = (String)properties.get("module.name");
        String applicationName = (String)properties.get("application.name");
        Context moduleContext = (Context)properties.get("module.context");
        Context appContext = (Context)properties.get("application.context");
        Context envContext = (Context)properties.get("env.context");
        EasyBeansDeployableInfo easyBeansDeployableInfo = new EasyBeansDeployableInfo();
        easyBeansDeployableInfo.setClassLoader(classLoader);
        easyBeansDeployableInfo.setApplicationJNDIResolver(applicationJNDIResolver);
        easyBeansDeployableInfo.setHasToBeUnpacked(Boolean.FALSE);
        JContainerConfig containerConfig = new JContainerConfig((IDeployable<?>)ejb3Deployable);
        easyBeansDeployableInfo.setContainerConfiguration(containerConfig);
        containerConfig.setApplicationName(applicationName);
        containerConfig.setModuleName(moduleName);
        containerConfig.setModuleContext(moduleContext);
        containerConfig.setAppContext(appContext);
        containerConfig.setEnvContext(envContext);
        ejb3Deployable.addExtension((IDeployableInfo)easyBeansDeployableInfo);
        return ejb3Deployable;
    }

    private EJB3Deployable getEJB3(EJBInWarArchive ejbInWarArchive) {
        IDeployable deployable = null;
        try {
            deployable = this.deployableHelper.getDeployable((IArchive)ejbInWarArchive);
        }
        catch (DeployableHelperException e) {
            LOGGER.error((Object)"Unable to get deployable from the archive ''{0}''", new Object[]{ejbInWarArchive, e});
        }
        if (deployable != null && deployable instanceof EJB3Deployable) {
            return (EJB3Deployable)EJB3Deployable.class.cast(deployable);
        }
        return null;
    }

    public void setDeployableHelper(IDeployableHelper deployableHelper) {
        this.deployableHelper = deployableHelper;
    }
}

