/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.transaction;

import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.SessionSynchronization;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.ow2.easybeans.api.EZBStatefulSessionFactory;
import org.ow2.easybeans.api.OperationState;
import org.ow2.easybeans.api.bean.EasyBeansSFSB;
import org.ow2.util.pool.api.Pool;
import org.ow2.util.pool.api.PoolException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSynchronizationListener
implements Synchronization {
    private SessionSynchronization synchronizedBean = null;
    private EasyBeansSFSB statefulBean = null;
    private EZBStatefulSessionFactory<EasyBeansSFSB, Long> factory = null;
    private Transaction tx = null;

    public SessionSynchronizationListener(SessionSynchronization synchronizedBean, EZBStatefulSessionFactory<EasyBeansSFSB, Long> factory, Transaction tx, EasyBeansSFSB statefulBean) {
        this.synchronizedBean = synchronizedBean;
        this.factory = factory;
        this.tx = tx;
        this.statefulBean = statefulBean;
    }

    public void beforeCompletion() {
        OperationState oldState = this.factory.getOperationState();
        this.factory.getOperationStateThreadLocal().set(OperationState.BEFORE_COMPLETION);
        try {
            try {
                this.synchronizedBean.beforeCompletion();
            }
            catch (EJBException e) {
                Pool pool = this.factory.getPool();
                try {
                    pool.discard((Object)this.statefulBean);
                }
                catch (PoolException pe) {
                    throw new EJBException("Unable to discard the instance", (Exception)((Object)pe));
                }
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Error in beforeCompletion()", (Exception)e);
            }
            Object var6_2 = null;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            this.factory.getOperationStateThreadLocal().set(oldState);
            throw throwable;
        }
        this.factory.getOperationStateThreadLocal().set(oldState);
        this.factory.unsetSessionSynchronizationListener(this.tx);
    }

    public void afterCompletion(int status) {
        OperationState oldState = this.factory.getOperationState();
        this.factory.getOperationStateThreadLocal().set(OperationState.AFTER_COMPLETION);
        try {
            try {
                this.synchronizedBean.afterCompletion(status == 3);
            }
            catch (EJBException e) {
                throw e;
            }
            catch (RemoteException e) {
                throw new EJBException("Error in afterCompletion()", (Exception)e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.factory.getOperationStateThreadLocal().set(oldState);
            throw throwable;
        }
        this.factory.getOperationStateThreadLocal().set(oldState);
    }
}

