/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.util.topological;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.ow2.easybeans.util.topological.GraphCycleException;
import org.ow2.easybeans.util.topological.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalSort<T extends Node> {
    private Collection<T> nodes = null;
    private List<T> sortedList = null;
    private Set<T> visitedNodes = null;
    private boolean sorted = false;

    public static <T extends Node> List<T> sort(Collection<T> nodes) {
        TopologicalSort<T> topologicalSort = new TopologicalSort<T>(nodes);
        topologicalSort.sort();
        return topologicalSort.getSortedList();
    }

    protected TopologicalSort(Collection<T> nodes) {
        this.nodes = nodes;
        this.sortedList = new ArrayList<T>();
        this.visitedNodes = new HashSet<T>();
    }

    protected void sort() {
        if (this.sorted) {
            return;
        }
        for (Node node : this.nodes) {
            this.visit(node, new Stack());
        }
        this.sorted = true;
    }

    protected List<T> getSortedList() {
        if (!this.sorted) {
            throw new IllegalStateException("Unable to get a sorted list as sort() has not been called");
        }
        return this.sortedList;
    }

    public void visit(T analyzingNode, Stack<T> stackVisitedNodes) {
        if (stackVisitedNodes.contains(analyzingNode)) {
            StringBuilder sb = new StringBuilder();
            sb.append("There is a cycle error for the node '");
            sb.append(analyzingNode.getName());
            sb.append("' and cycle is made between the nodes '");
            sb.append(stackVisitedNodes);
            sb.append("'. Dependencies are : \n");
            for (Node stackNode : stackVisitedNodes) {
                sb.append(" ( ");
                sb.append(stackNode.getName());
                sb.append("--->");
                sb.append(stackNode.getDependencies());
                sb.append(" )");
            }
            throw new GraphCycleException(sb.toString());
        }
        if (!this.visitedNodes.contains(analyzingNode)) {
            this.visitedNodes.add(analyzingNode);
            for (Node node : this.nodes) {
                if (!analyzingNode.getDependencies().contains(node)) continue;
                stackVisitedNodes.push(analyzingNode);
                this.visit(node, stackVisitedNodes);
                stackVisitedNodes.pop();
            }
            this.sortedList.add(analyzingNode);
        }
    }
}

