/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import javax.ejb.EJBException;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.ejb21.JEntityContext;
import org.ow2.jonas.lib.ejb21.JEntityFactory;
import org.ow2.jonas.lib.ejb21.JEntitySwitchCST;
import org.ow2.jonas.lib.ejb21.TraceEjb;

public class JEntitySwitchCS
extends JEntitySwitchCST {
    protected long passivationTimeout;
    protected long ptimestamp;

    public JEntitySwitchCS() {
        this.lockpolicy = 1;
        this.txUpdates = false;
    }

    @Override
    protected void initpolicy(JEntityFactory bf) {
        this.lazyregister = false;
        this.passivationTimeout = bf.getPassivationTimeout() * 1000;
        this.ptimestamp = System.currentTimeMillis();
    }

    @Override
    public void waitmyturn(Transaction tx) {
        if (tx == null) {
            while (this.runningtx != null) {
                if (TraceEjb.isDebugSynchro()) {
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IH: WAIT end IT"));
                }
                ++this.waiters;
                try {
                    this.wait(10000L);
                    if (!TraceEjb.isDebugSynchro()) continue;
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IH: NOTIFIED"));
                }
                catch (InterruptedException e) {
                    if (!TraceEjb.isDebugSynchro()) continue;
                    TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IH: INTERRUPTED"));
                }
                catch (Exception e) {
                    throw new EJBException("JEntitySwitch synchronization pb", e);
                }
                finally {
                    --this.waiters;
                }
            }
        } else {
            int waitcount = 0;
            Transaction lastrunning = null;
            while (this.inDirtyList || this.runningtx != null && !tx.equals(this.runningtx)) {
                if (this.inDirtyList) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: WAIT end IH"));
                    }
                    this.bf.synchronizeEntities();
                } else {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: WAIT end IT"));
                    }
                    this.blockedtx.add(tx);
                    if (waitcount > 0 && this.runningtx.equals(lastrunning) && this.bf.isDeadLocked(this.runningtx)) {
                        this.blockedtx.remove(tx);
                        try {
                            tx.setRollbackOnly();
                        }
                        catch (SystemException e) {
                            TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception setting rollbackonly"));
                        }
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                        throw new TransactionRolledbackLocalException("possible deadlock");
                    }
                    lastrunning = this.runningtx;
                }
                ++waitcount;
                ++this.waiters;
                try {
                    this.wait(this.deadlockTimeout);
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: NOTIFIED"));
                    }
                }
                catch (InterruptedException e) {
                    if (TraceEjb.isDebugSynchro()) {
                        TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + "mapICtx IT: INTERRUPTED"));
                    }
                }
                catch (Exception e) {
                    throw new EJBException("JEntitySwitch synchronization pb", e);
                }
                finally {
                    --this.waiters;
                    if (lastrunning != null) {
                        this.blockedtx.remove(tx);
                    }
                }
                int status = 4;
                try {
                    status = tx.getStatus();
                }
                catch (SystemException e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)(this.ident + "getICtx IT: unexpected exception getting transaction status"));
                }
                switch (status) {
                    case 1: 
                    case 4: 
                    case 9: {
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)(this.ident + "getICtx IT: transaction rolled back"));
                        throw new TransactionRolledbackLocalException("rollback occured while waiting");
                    }
                }
            }
        }
    }

    @Override
    public synchronized int passivateIH(boolean store, boolean passivate) {
        int ret;
        JEntityContext jec = this.getContext4Tx(null);
        boolean toStore = store;
        if (!store && this.inDirtyList) {
            boolean bl = toStore = System.currentTimeMillis() - this.ptimestamp > this.passivationTimeout;
        }
        if (this.runningtx != null || this.countIT > 0) {
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " used in TX"));
            }
            return 2;
        }
        if (this.countIH > 0) {
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " used off TX"));
            }
            this.mustStore = toStore;
            return toStore ? 0 : 1;
        }
        int n = ret = toStore ? 1 : 2;
        if (jec != null) {
            if (jec.isMarkedRemoved()) {
                this.discardContext(null, true, true);
                return 1;
            }
            if (toStore) {
                if (TraceEjb.isDebugContext()) {
                    TraceEjb.context.log(BasicLevel.DEBUG, (Object)(this.ident + " store object"));
                }
                try {
                    jec.storeIfModified();
                }
                catch (Exception e) {
                    TraceEjb.logger.log(BasicLevel.ERROR, (Object)this.ident, (Object)" error while storing bean state:", (Object)e);
                }
                this.mustStore = false;
                this.ptimestamp = System.currentTimeMillis();
            }
            if (!passivate) {
                return ret;
            }
            if (System.currentTimeMillis() < this.estimestamp) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)"too recent ");
                return ret;
            }
            if (TraceEjb.isDebugContext()) {
                TraceEjb.context.log(BasicLevel.DEBUG, (Object)("passivate: " + jec));
            }
            if (!jec.passivate()) {
                return ret;
            }
            if (jec.getMyTx() != null) {
                TraceEjb.context.log(BasicLevel.WARN, (Object)"Will forget Tx???");
            }
            this.bf.releaseJContext(jec, 1);
            this.removeContext4Tx(null);
            if (this.waiters > 0) {
                this.notifyAll();
            }
        }
        if (this.inactivityTimeout > 0L && System.currentTimeMillis() - this.estimestamp > this.inactivityTimeout) {
            this.detachPk();
            this.estimestamp = System.currentTimeMillis();
            ret = 0;
        }
        return ret;
    }

    @Override
    public synchronized void endIH() {
        if (this.waiters > 0) {
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " notify"));
            }
            this.notifyAll();
        }
        this.inDirtyList = false;
        if (this.getContext4Tx(null) == null) {
            if (TraceEjb.isDebugSynchro()) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " discarded!"));
            }
            return;
        }
        if (TraceEjb.isDebugSynchro()) {
            if (this.countIH == 0) {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " ready again"));
            } else {
                TraceEjb.synchro.log(BasicLevel.DEBUG, (Object)(this.ident + " busy!"));
            }
        }
    }
}

