/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21;

import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.RemoveException;
import javax.ejb.SessionSynchronization;
import javax.ejb.TransactionRolledbackLocalException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.jndi.checker.api.IResourceChecker;
import org.ow2.jonas.lib.ejb21.JSessionContext;
import org.ow2.jonas.lib.ejb21.JSessionSwitch;
import org.ow2.jonas.lib.ejb21.JStatefulContext;
import org.ow2.jonas.lib.ejb21.JStatefulFactory;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.TraceEjb;
import org.ow2.jonas.tm.Enlistable;

public class JStatefulSwitch
extends JSessionSwitch {
    private int sessionId;
    private int usedcount = 0;
    private JStatefulContext bctx = null;
    private Transaction currTx = null;
    private boolean mustCommit = false;
    private boolean expired = false;
    private Transaction beanTx = null;
    private long lastaccesstime;
    private boolean passivated = false;
    private List<IResourceChecker> resources = new ArrayList<IResourceChecker>();
    private List connectionList = Collections.synchronizedList(new ArrayList());

    public JStatefulSwitch(JStatefulFactory bf) throws RemoteException {
        super(bf);
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public boolean canPassivate() {
        if (this.usedcount > 0) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Victim is busy");
            return false;
        }
        return !this.passivated && this.bctx != null;
    }

    public boolean isPassivated() {
        return this.passivated;
    }

    public synchronized boolean passivate() {
        if (this.currTx != null || this.beanTx != null) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Cannot passivate: busy");
            return false;
        }
        TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Instance will be passivated");
        this.passivated = ((JStatefulFactory)this.bf).passivateStateful(this);
        if (this.passivated) {
            this.bctx.setInstance(null);
        }
        return this.passivated;
    }

    public void setConnectionList(List cl) {
        this.connectionList = cl;
        if (TraceEjb.isDebugTx()) {
            TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("init connectionList =" + this.connectionList));
        }
    }

    @Override
    public void enlistConnections(Transaction tx) {
        if (tx != null && this.connectionList != null) {
            try {
                for (Enlistable rme : this.connectionList) {
                    if (rme != null) {
                        rme.enlistConnection(tx);
                        continue;
                    }
                    TraceEjb.tx.log(BasicLevel.WARN, (Object)"Null element in Connection List");
                }
            }
            catch (SystemException e) {
                TraceEjb.tx.log(BasicLevel.ERROR, (Object)"cannot enlist connection", (Throwable)e);
            }
        }
        this.bf.getTransactionManager().pushConnectionList(this.connectionList);
        if (this.resources != null) {
            for (IResourceChecker resourceChecker : this.resources) {
                this.bf.getResourceCheckerManager().enlistResource(resourceChecker);
            }
        }
    }

    @Override
    public void delistConnections(Transaction tx) {
        this.connectionList = this.bf.getTransactionManager().popConnectionList();
        if (tx != null && this.connectionList != null) {
            try {
                for (Enlistable rme : this.connectionList) {
                    if (rme != null) {
                        rme.delistConnection(tx);
                        continue;
                    }
                    TraceEjb.tx.log(BasicLevel.WARN, (Object)"Null element in Connection List");
                }
            }
            catch (SystemException e) {
                TraceEjb.tx.log(BasicLevel.ERROR, (Object)"cannot delist connection", (Throwable)e);
            }
        }
    }

    public synchronized void timeoutExpired(Object arg) {
        if (TraceEjb.isVerbose()) {
            TraceEjb.logger.log(BasicLevel.WARN, (Object)"stateful session timeout expired");
        }
        this.mytimer = null;
        if (this.currTx != null) {
            this.expired = true;
        } else {
            block8: {
                if (this.bctx != null) {
                    try {
                        this.bctx.setRemoved();
                    }
                    catch (RemoteException e) {
                        if (TraceEjb.isVerbose()) {
                            TraceEjb.logger.log(BasicLevel.WARN, (Object)"timeout expired", (Throwable)e);
                        }
                    }
                    catch (RemoveException e) {
                        if (!TraceEjb.isVerbose()) break block8;
                        TraceEjb.logger.log(BasicLevel.WARN, (Object)"timeout expired", (Throwable)e);
                    }
                }
            }
            this.noLongerUsed();
        }
    }

    public JStatefulContext getStatefulContext() {
        if (this.sessionId == -1) {
            throw new EJBException("This Session has been removed");
        }
        if (this.bctx == null) {
            throw new EJBException("Already passivated");
        }
        return this.bctx;
    }

    @Override
    public synchronized JSessionContext getICtx(Transaction tx) {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.sessionId == -1) {
            throw new NoSuchObjectLocalException("This Session has been removed");
        }
        this.lastaccesstime = System.currentTimeMillis();
        if (this.passivated) {
            TraceEjb.ssfpool.log(BasicLevel.DEBUG, (Object)"Bean has been passivated. Reactivate it");
            ((JStatefulFactory)this.bf).activateStateful(this);
            this.passivated = false;
        }
        this.checkTx(tx);
        ++this.usedcount;
        return this.bctx;
    }

    public synchronized void bindICtx(Transaction tx, JStatefulContext bctx) {
        this.sessionId = ((JStatefulFactory)this.bf).getNewSessionId(this);
        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Id=" + this.sessionId));
        this.bctx = bctx;
        bctx.initSessionContext(this);
        this.lastaccesstime = System.currentTimeMillis();
        this.resources = new ArrayList<IResourceChecker>();
        ++this.usedcount;
        this.checkTx(tx);
    }

    @Override
    public synchronized void releaseICtx(RequestCtx req, boolean discard) {
        TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Id=" + this.sessionId));
        --this.usedcount;
        if (this.bctx == null) {
            return;
        }
        if (this.bctx.isMarkedRemoved() || discard) {
            this.stopTimer();
            this.noLongerUsed();
        }
    }

    @Override
    public void noLongerUsed() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.myremote != null) {
            try {
                this.myremote.unexportObject();
            }
            catch (NoSuchObjectException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"unexportObject failed", (Throwable)e);
            }
        }
        if (this.beanTx != null) {
            TraceEjb.tx.log(BasicLevel.WARN, (Object)"transaction not ended. forget it");
            this.beanTx = null;
        }
        this.bf.removeEJB(this);
        ((JStatefulFactory)this.bf).removeStateful(this.sessionId);
        this.bctx = null;
        this.sessionId = -1;
        this.passivated = false;
        this.usedcount = 0;
    }

    public void txCompleted() {
        if (TraceEjb.isDebugIc()) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("Id=" + this.sessionId));
        }
        this.currTx = null;
        if (this.expired) {
            this.timeoutExpired(null);
        }
    }

    public boolean isInTransaction() {
        if (TraceEjb.isDebugIc() && this.currTx != null) {
            TraceEjb.interp.log(BasicLevel.DEBUG, (Object)("currTx=" + this.currTx));
            if (this.mustCommit) {
                TraceEjb.interp.log(BasicLevel.DEBUG, (Object)"mustCommit");
            }
        }
        return this.currTx != null && !this.mustCommit;
    }

    @Override
    public void setMustCommit(boolean mc) {
        this.mustCommit = mc;
    }

    @Override
    public void saveBeanTx() {
        if (this.bf.isTxBeanManaged()) {
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Id=" + this.sessionId));
            }
            try {
                this.beanTx = this.bf.getTransactionManager().suspend();
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot suspend transaction:", (Throwable)e);
            }
        }
        this.saveOpenResources();
    }

    public void saveOpenResources() {
        List listOfOpenedResources = this.bf.getResourceCheckerManager().getResources();
        if (listOfOpenedResources != null) {
            for (IResourceChecker resource : listOfOpenedResources) {
                if (this.resources.contains(resource)) continue;
                this.resources.add(resource);
            }
        }
    }

    public long getLastAccessTime() {
        return this.lastaccesstime;
    }

    private synchronized void checkTx(Transaction tx) {
        if (!this.bf.isSessionSynchro() && this.bf.isTxBeanManaged() && this.beanTx != null) {
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("resuming Bean Managed Tx Id=" + this.sessionId));
            }
            try {
                this.bf.getTransactionManager().resume(this.beanTx);
            }
            catch (SystemException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"cannot resume transaction", (Throwable)e);
            }
            catch (InvalidTransactionException e) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"Cannot resume transaction", (Throwable)e);
            }
            return;
        }
        if (tx == null) {
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("(No Tx)Id=" + this.sessionId));
            }
            if (this.currTx != null && this.bf.isSessionSynchro()) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"synchronized session called outside transaction context");
                throw new EJBException("Synchronized session called outside transaction context");
            }
        } else {
            if (TraceEjb.isDebugTx()) {
                TraceEjb.tx.log(BasicLevel.DEBUG, (Object)("Tx=" + tx));
            }
            if (this.currTx == null) {
                if (this.bf.isSessionSynchro()) {
                    try {
                        SessionSynchronization ssbean = (SessionSynchronization)this.bctx.getInstance();
                        if (ssbean == null) {
                            throw new EJBException("Instance should have been reactivated first.");
                        }
                        tx.registerSynchronization((Synchronization)this.bctx);
                        ssbean.afterBegin();
                    }
                    catch (RollbackException e) {
                        throw new TransactionRolledbackLocalException("Session rolled back");
                    }
                    catch (SystemException e) {
                        throw new EJBException("checkTx error", (Exception)((Object)e));
                    }
                    catch (RemoteException e) {
                        throw new EJBException("checkTx error", (Exception)e);
                    }
                }
                try {
                    tx.registerSynchronization((Synchronization)this.bctx);
                }
                catch (RollbackException e) {
                    throw new TransactionRolledbackLocalException("Session rolled back");
                }
                catch (SystemException e) {
                    throw new EJBException("checkTx error", (Exception)((Object)e));
                }
                this.currTx = tx;
            } else if (!tx.equals(this.currTx)) {
                TraceEjb.logger.log(BasicLevel.ERROR, (Object)"synchronized session called in another transaction context");
                throw new EJBException("Synchronized session called in another transaction context");
            }
        }
    }

    public List<IResourceChecker> getResources() {
        return this.resources;
    }
}

