/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.sql;

import java.util.Stack;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.ASTInputParameter;
import org.ow2.jonas.deployment.ejb.ejbql.ASTIntegerLiteral;
import org.ow2.jonas.deployment.ejb.ejbql.ASTLimitClause;
import org.ow2.jonas.deployment.ejb.ejbql.ASTLimitExpression;
import org.ow2.jonas.deployment.ejb.ejbql.ParseException;
import org.ow2.jonas.deployment.ejb.ejbql.SimpleNode;
import org.ow2.jonas.lib.ejb21.sql.EjbqlAbstractVisitor;
import org.ow2.jonas.lib.ejb21.sql.EjbqlLimiterRange;

public class EjbqlLimitVisitor
extends EjbqlAbstractVisitor {
    private Class[] paramTypes;
    private EjbqlLimiterRange[] ranges = new EjbqlLimiterRange[0];

    public EjbqlLimitVisitor(ASTEJBQL ejbql, Class[] paramTypes) throws Exception {
        this.paramTypes = paramTypes;
        this.visit((SimpleNode)ejbql);
    }

    public EjbqlLimiterRange[] getLimiterRanges() {
        return this.ranges;
    }

    @Override
    public Object visit(ASTLimitClause node, Object data) {
        this.visit((SimpleNode)node, data);
        Stack s = (Stack)data;
        this.ranges = new EjbqlLimiterRange[s.size()];
        if (s.size() > 1) {
            this.ranges[1] = (EjbqlLimiterRange)s.pop();
        }
        this.ranges[0] = (EjbqlLimiterRange)s.pop();
        return null;
    }

    @Override
    public Object visit(ASTLimitExpression node, Object data) {
        this.visit((SimpleNode)node, data);
        return null;
    }

    @Override
    public Object visit(ASTIntegerLiteral node, Object data) {
        ((Stack)data).push(new EjbqlLimiterRange(1, ((Long)node.value).intValue()));
        return null;
    }

    @Override
    public Object visit(ASTInputParameter node, Object data) {
        try {
            int pIndex = (Integer)node.value - 1;
            if (pIndex >= this.paramTypes.length) {
                throw new ParseException("Parameter ?" + (pIndex + 1) + " is out of range (max=" + this.paramTypes.length + ")");
            }
            ((Stack)data).push(new EjbqlLimiterRange(2, pIndex));
            return null;
        }
        catch (ParseException e) {
            throw new EjbqlAbstractVisitor.VisitorException((Exception)((Object)e));
        }
    }
}

