/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.loader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.ow2.jonas.lib.loader.factory.URLFactory;
import org.ow2.jonas.lib.loader.locator.Locator;

public abstract class AbsModuleClassLoader
extends URLClassLoader {
    private URLFactory[] factories;
    private Locator[] locators;
    private URL[] bases;

    public AbsModuleClassLoader(URL[] modules) throws IOException {
        super(new URL[0]);
        this.bases = modules;
        this.init();
    }

    public AbsModuleClassLoader(URL[] modules, ClassLoader parent) throws IOException {
        super(new URL[0], parent);
        this.bases = modules;
        this.init();
    }

    protected void init() throws IOException {
        this.factories = new URLFactory[this.bases.length];
        this.locators = new Locator[this.bases.length];
        for (int i = 0; i < this.bases.length; ++i) {
            this.factories[i] = URLFactory.getFactory(this.bases[i]);
            this.locators[i] = Locator.getLocator(this.bases[i]);
        }
    }

    protected void addInRepository(String location) throws IOException {
        for (int i = 0; i < this.bases.length; ++i) {
            if (!this.locators[i].hasDirectory(location) && !this.locators[i].hasFile(location)) continue;
            this.addURL(this.factories[i].getURL(location));
        }
    }

    protected void addContentInRepository(String location) throws IOException {
        for (int i = 0; i < this.bases.length; ++i) {
            List list = this.locators[i].listContent(location);
            Iterator l = list.iterator();
            while (l.hasNext()) {
                this.addURL(this.factories[i].getURL((String)l.next()));
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("classloader : " + this.getClass().getName() + "\n");
        sb.append("\tmodules bases (not in loader!) : \n");
        for (int i = 0; i < this.bases.length; ++i) {
            sb.append("\t\t -" + this.bases[i] + "\n");
        }
        sb.append("\trepositories :\n");
        URL[] rep = this.getURLs();
        for (int i = 0; i < rep.length; ++i) {
            sb.append("\t\t -" + rep[i] + "\n");
        }
        sb.append("\tparent : " + this.getParent() + "\n");
        return sb.toString();
    }

    public URL[] getBases() {
        return this.bases;
    }

    public String getClasspath() {
        URL[] urls = this.getURLs();
        StringBuffer cp = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i].getFile();
            if (url.indexOf("!/") != -1) continue;
            cp.append(File.pathSeparator + url);
        }
        if (this.getParent() instanceof AbsModuleClassLoader) {
            AbsModuleClassLoader module = (AbsModuleClassLoader)this.getParent();
            cp.append(module.getClasspath());
        }
        return cp.toString();
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

