/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.deployable.factory;

import java.util.Collection;
import java.util.HashSet;
import org.ow2.util.archive.api.IFileArchive;
import org.ow2.util.ee.deploy.api.deployable.FileDeployable;
import org.ow2.util.ee.deploy.api.deployable.factory.FileDeployableException;
import org.ow2.util.ee.deploy.api.deployable.factory.IFileDeployableFactory;
import org.ow2.util.ee.deploy.api.deployable.factory.IFileDeployableFactoryManager;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFileDeployableFactoryManager
implements IFileDeployableFactoryManager {
    private static Log logger = LogFactory.getLog(DefaultFileDeployableFactoryManager.class);
    private Collection<IFileDeployableFactory> fileDeployableFactories = new HashSet<IFileDeployableFactory>();

    @Override
    public FileDeployable<?, ?> getFileDeployable(IFileArchive fileArchive) throws FileDeployableException {
        FileDeployable<?, ?> fileDeployable = null;
        for (IFileDeployableFactory factory : this.fileDeployableFactories) {
            try {
                fileDeployable = factory.getFileDeployable(fileArchive);
                return fileDeployable;
            }
            catch (FileDeployableException e) {
                logger.warn((Object)"factory {0} doesn''t support archive {1}", new Object[]{factory, fileArchive, e});
            }
        }
        throw new FileDeployableException();
    }

    @Override
    public void addFileDeployableFactory(IFileDeployableFactory factory) {
        this.fileDeployableFactories.add(factory);
    }

    @Override
    public void removeFileDeployableFactory(IFileDeployableFactory factory) {
        this.fileDeployableFactories.remove(factory);
    }
}

