/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.deploy.impl.helper;

import java.util.ArrayList;
import java.util.List;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.helper.DeployableHelperException;
import org.ow2.util.ee.deploy.api.helper.IDeployableAnalyser;
import org.ow2.util.ee.deploy.api.helper.IDeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableAnalyserTracker;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployableHelperComponent
implements IDeployableHelper {
    private List<IDeployableAnalyser> deployableAnalysers = new ArrayList<IDeployableAnalyser>();
    private static Log logger = LogFactory.getLog(DeployableHelperComponent.class);
    private DeployableAnalyserTracker deployableAnalyserTracker;

    public DeployableHelperComponent(DeployableAnalyserTracker deployableAnalyserTracker) {
        this.deployableAnalyserTracker = deployableAnalyserTracker;
    }

    @Override
    public IDeployable<?> getDeployable(IArchive archive) throws DeployableHelperException {
        return this.getDeployable(archive, true);
    }

    @Override
    public IDeployable<?> getDeployable(IArchive archive, boolean isOSGiEnabled) throws DeployableHelperException {
        IDeployable<?> deployable = null;
        Object[] deployableAnalysers = this.deployableAnalyserTracker.getServices();
        if (deployableAnalysers != null) {
            for (Object deployableAnalyser : deployableAnalysers) {
                deployable = ((IDeployableAnalyser)deployableAnalyser).analyze(archive);
                if (deployable == null) continue;
                return deployable;
            }
        }
        return DeployableHelper.getDeployable(archive, isOSGiEnabled);
    }
}

