/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.tcp.QueueTcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TcpConnectionFactory;
import org.objectweb.joram.client.jms.tcp.TopicTcpConnectionFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class DefaultConnectionManager
implements ConnectionManager,
Serializable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)DefaultConnectionManager.class.getName());
    private static DefaultConnectionManager ref = null;

    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo cxRequest) throws ResourceException {
        String identityClass;
        String password;
        String userName;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " allocateConnection(" + mcf + "," + cxRequest + ")"));
        }
        if (cxRequest == null) {
            userName = ((ManagedConnectionFactoryImpl)mcf).getUserName();
            password = ((ManagedConnectionFactoryImpl)mcf).getPassword();
            identityClass = ((ManagedConnectionFactoryImpl)mcf).getIdentityClass();
        } else {
            userName = ((ConnectionRequest)cxRequest).getUserName();
            password = ((ConnectionRequest)cxRequest).getPassword();
            identityClass = ((ConnectionRequest)cxRequest).getIdentityClass();
        }
        String hostName = ((ManagedConnectionFactoryImpl)mcf).getHostName();
        int serverPort = ((ManagedConnectionFactoryImpl)mcf).getServerPort();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " allocateConnection: hostName = " + hostName + ", serverPort = " + serverPort));
        }
        try {
            if (cxRequest instanceof QueueConnectionRequest) {
                QueueConnectionFactory factory = QueueTcpConnectionFactory.create((String)hostName, (int)serverPort);
                this.setFactoryParameters((AbstractConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
                ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                return factory.createQueueConnection(userName, password);
            }
            if (cxRequest instanceof TopicConnectionRequest) {
                TopicConnectionFactory factory = TopicTcpConnectionFactory.create((String)hostName, (int)serverPort);
                this.setFactoryParameters((AbstractConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
                ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
                return factory.createTopicConnection(userName, password);
            }
            ConnectionFactory factory = TcpConnectionFactory.create((String)hostName, (int)serverPort);
            this.setFactoryParameters((AbstractConnectionFactory)factory, (ManagedConnectionFactoryImpl)mcf);
            ((AbstractConnectionFactory)factory).setIdentityClassName(identityClass);
            return factory.createConnection(userName, password);
        }
        catch (IllegalStateException exc) {
            throw new CommException("Could not access the JORAM server: " + (Object)((Object)exc));
        }
        catch (JMSSecurityException exc) {
            throw new SecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (JMSException exc) {
            throw new ResourceException("Failed connecting process: " + (Object)((Object)exc));
        }
    }

    private void setFactoryParameters(AbstractConnectionFactory factory, ManagedConnectionFactoryImpl mcf) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " setFactoryParameters(" + factory + "," + mcf + ")"));
        }
        mcf.setParameters(factory);
    }

    static DefaultConnectionManager getRef() {
        if (ref == null) {
            ref = new DefaultConnectionManager();
        }
        return ref;
    }
}

