/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.ConnectionRequest;
import org.objectweb.joram.client.connector.DefaultConnectionManager;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedQueueConnectionFactoryImpl;
import org.objectweb.joram.client.connector.ManagedTopicConnectionFactoryImpl;
import org.objectweb.joram.client.connector.QueueConnectionRequest;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundConnectionFactory
implements ConnectionFactory,
Serializable,
Referenceable {
    private static final long serialVersionUID = 1L;
    public static Logger logger = Debug.getLogger((String)OutboundConnectionFactory.class.getName());
    protected ManagedConnectionFactoryImpl mcf;
    protected ConnectionManager cxManager;
    protected Reference reference;

    OutboundConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cxManager) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundConnectionFactory(" + mcf + ", " + cxManager + ")"));
        }
        this.mcf = mcf;
        this.cxManager = cxManager != null ? cxManager : DefaultConnectionManager.getRef();
    }

    public Connection createConnection() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnection()"));
        }
        return this.createConnection(this.mcf.getUserName(), this.mcf.getPassword());
    }

    public Connection createConnection(String userName, String password) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConnection(" + userName + ", " + password + ")"));
        }
        try {
            ConnectionRequest cxRequest = null;
            cxRequest = this.mcf instanceof ManagedQueueConnectionFactoryImpl ? new QueueConnectionRequest(userName, password, this.mcf.getIdentityClass()) : (this.mcf instanceof ManagedTopicConnectionFactoryImpl ? new TopicConnectionRequest(userName, password, this.mcf.getIdentityClass()) : new ConnectionRequest(userName, password, this.mcf.getIdentityClass()));
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createConnection cxManager = " + this.cxManager));
            }
            Object o = this.cxManager.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cxRequest);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(this + " createConnection connection = " + o));
            }
            return (Connection)o;
        }
        catch (SecurityException exc) {
            throw new JMSSecurityException("Invalid user identification: " + (Object)((Object)exc));
        }
        catch (CommException exc) {
            throw new IllegalStateException("Could not connect to the JORAM server: " + (Object)((Object)exc));
        }
        catch (ResourceException exc) {
            throw new JMSException("Could not create connection: " + (Object)((Object)exc));
        }
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public Reference getReference() {
        return this.reference;
    }
}

