/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundConsumer
implements MessageConsumer {
    public static Logger logger = Debug.getLogger((String)OutboundConsumer.class.getName());
    protected OutboundSession session;
    protected MessageConsumer consumer;
    boolean valid = true;

    OutboundConsumer(MessageConsumer consumer, OutboundSession session) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundConsumer(" + consumer + ", " + session + ")"));
        }
        this.consumer = consumer;
        this.session = session;
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Invalid call on a component's producer.");
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Invalid call on a component's producer.");
    }

    public String getMessageSelector() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getMessageSelector()"));
        }
        this.checkValidity();
        return this.consumer.getMessageSelector();
    }

    public Message receive(long timeOut) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " receive(" + timeOut + ")"));
        }
        this.checkValidity();
        return this.consumer.receive(timeOut);
    }

    public Message receive() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " receive()"));
        }
        this.checkValidity();
        return this.consumer.receive();
    }

    public Message receiveNoWait() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " receiveNoWait()"));
        }
        this.checkValidity();
        if (!this.session.isStarted()) {
            return null;
        }
        return this.consumer.receiveNoWait();
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " close()"));
        }
        this.valid = false;
        this.consumer.close();
    }

    protected void checkValidity() throws IllegalStateException {
        this.session.checkValidity();
        if (!this.valid) {
            throw new IllegalStateException("Invalid call on a closed producer.");
        }
    }
}

