/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.objectweb.joram.client.connector.OutboundProducer;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundPublisher
extends OutboundProducer
implements TopicPublisher {
    public static Logger logger = Debug.getLogger((String)OutboundPublisher.class.getName());

    OutboundPublisher(MessageProducer producer, OutboundSession session) {
        super(producer, session);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundPublisher(" + producer + ", " + session + ")"));
        }
    }

    public Topic getTopic() throws JMSException {
        this.checkValidity();
        return (Topic)this.producer.getDestination();
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " publish(" + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Message message) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " publish(" + message + ")"));
        }
        this.checkValidity();
        this.producer.send(message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " publish(" + topic + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send((Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " publish(" + topic + ", " + message + ")"));
        }
        this.checkValidity();
        this.producer.send((Destination)topic, message);
    }
}

