/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.objectweb.joram.client.connector.OutboundProducer;
import org.objectweb.joram.client.connector.OutboundSession;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundSender
extends OutboundProducer
implements QueueSender {
    public static Logger logger = Debug.getLogger((String)OutboundSender.class.getName());

    OutboundSender(MessageProducer producer, OutboundSession session) {
        super(producer, session);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundSender(" + producer + ", " + session + ")"));
        }
    }

    public Queue getQueue() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getQueue() = " + this.producer.getDestination()));
        }
        this.checkValidity();
        return (Queue)this.producer.getDestination();
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " send(" + queue + ", " + message + ", " + deliveryMode + ", " + priority + ", " + timeToLive + ")"));
        }
        this.checkValidity();
        this.producer.send((Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " send(" + queue + ", " + message + ")"));
        }
        this.checkValidity();
        this.producer.send((Destination)queue, message);
    }
}

