/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import fr.dyade.aaa.common.Debug;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;
import org.objectweb.joram.client.connector.OutboundConnection;
import org.objectweb.joram.client.connector.OutboundConsumer;
import org.objectweb.joram.client.connector.OutboundProducer;
import org.objectweb.joram.client.connector.OutboundSubscriber;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class OutboundSession
implements Session {
    public static Logger logger = Debug.getLogger((String)OutboundSession.class.getName());
    protected OutboundConnection cnx;
    Session sess;
    boolean valid = true;
    boolean started = false;
    protected boolean transacted;

    OutboundSession(Session sess, OutboundConnection cnx) {
        this.sess = sess;
        this.cnx = cnx;
        cnx.sessions.add(this);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundSession(" + sess + ", " + cnx + ") cnx.sessions = " + cnx.sessions));
        }
    }

    OutboundSession(Session sess, OutboundConnection cnx, boolean transacted) {
        this.sess = sess;
        this.cnx = cnx;
        this.transacted = transacted;
        cnx.sessions.add(this);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("OutboundSession(" + sess + ", " + cnx + ", " + transacted + ") cnx.sessions = " + cnx.sessions));
        }
    }

    public int getAcknowledgeMode() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getAcknowledgeMode() = " + this.sess.getAcknowledgeMode()));
        }
        this.checkValidity();
        if (this.transacted) {
            return 0;
        }
        return this.sess.getAcknowledgeMode();
    }

    public boolean getTransacted() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " getTransacted() = " + this.sess.getTransacted()));
        }
        this.checkValidity();
        return this.sess.getTransacted();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Forbidden call on a component's session.");
    }

    public MessageListener getMessageListener() throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Forbidden call on a component's session.");
    }

    public Message createMessage() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createMessage()"));
        }
        this.checkValidity();
        return this.sess.createMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTextMessage()"));
        }
        this.checkValidity();
        return this.sess.createTextMessage();
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTextMessage(" + text + ")"));
        }
        this.checkValidity();
        return this.sess.createTextMessage(text);
    }

    public BytesMessage createBytesMessage() throws JMSException {
        this.checkValidity();
        return this.sess.createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        this.checkValidity();
        return this.sess.createMapMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        this.checkValidity();
        return this.sess.createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable obj) throws JMSException {
        this.checkValidity();
        return this.sess.createObjectMessage(obj);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        this.checkValidity();
        return this.sess.createStreamMessage();
    }

    public QueueBrowser createBrowser(Queue queue, String selector) throws JMSException {
        this.checkValidity();
        return this.sess.createBrowser(queue, selector);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        this.checkValidity();
        return this.sess.createBrowser(queue);
    }

    public MessageProducer createProducer(Destination dest) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createProducer(" + dest + ")"));
        }
        this.checkValidity();
        return new OutboundProducer(this.sess.createProducer(dest), this);
    }

    public MessageConsumer createConsumer(Destination dest, String selector, boolean noLocal) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConsumer(" + dest + ", " + selector + ", " + noLocal + ")"));
        }
        this.checkValidity();
        return new OutboundConsumer(this.sess.createConsumer(dest, selector, noLocal), this);
    }

    public MessageConsumer createConsumer(Destination dest, String selector) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConsumer(" + dest + ", " + selector + ")"));
        }
        this.checkValidity();
        return new OutboundConsumer(this.sess.createConsumer(dest, selector), this);
    }

    public MessageConsumer createConsumer(Destination dest) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createConsumer(" + dest + ")"));
        }
        this.checkValidity();
        return new OutboundConsumer(this.sess.createConsumer(dest), this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String selector, boolean noLocal) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createDurableSubscriber(" + topic + ", " + name + ", " + selector + ", " + noLocal + ")"));
        }
        this.checkValidity();
        TopicSubscriber sub = this.sess.createDurableSubscriber(topic, name, selector, noLocal);
        return new OutboundSubscriber(topic, noLocal, (MessageConsumer)sub, this);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createDurableSubscriber(" + topic + ", " + name + ")"));
        }
        this.checkValidity();
        TopicSubscriber sub = this.sess.createDurableSubscriber(topic, name);
        return new OutboundSubscriber(topic, false, (MessageConsumer)sub, this);
    }

    public Queue createQueue(String queueName) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createQueue(" + queueName + ")"));
        }
        this.checkValidity();
        return this.sess.createQueue(queueName);
    }

    public Topic createTopic(String topicName) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTopic(" + topicName + ")"));
        }
        this.checkValidity();
        return this.sess.createTopic(topicName);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTemporaryQueue()"));
        }
        this.checkValidity();
        return this.sess.createTemporaryQueue();
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " createTemporaryTopic()"));
        }
        this.checkValidity();
        return this.sess.createTemporaryTopic();
    }

    public void run() {
    }

    public void commit() throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Forbidden call on a component's session.");
    }

    public void rollback() throws JMSException {
        this.checkValidity();
        throw new IllegalStateException("Forbidden call on a component's session.");
    }

    public void recover() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " recover()"));
        }
        this.checkValidity();
        this.sess.recover();
    }

    public void unsubscribe(String name) throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " unsubscribe(" + name + ")"));
        }
        this.checkValidity();
        this.sess.unsubscribe(name);
    }

    void start() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " start() started = true"));
        }
        this.started = true;
    }

    public void close() throws JMSException {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(this + " close()"));
        }
        this.valid = false;
        this.cnx.sessions.remove(this);
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    void checkValidity() throws IllegalStateException {
        boolean validity = !this.valid ? false : this.cnx.valid;
        if (!validity) {
            throw new IllegalStateException("Invalid state: session is closed.");
        }
    }

    public String toString() {
        return "Outbound [" + this.sess.toString() + "]@" + this.hashCode();
    }
}

