/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.api.naming.EZBNamingStrategy;
import org.ow2.easybeans.deployment.EasyBeansDeployableInfo;
import org.ow2.easybeans.deployment.api.EZBDeployableInfo;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.server.Embedded;
import org.ow2.jonas.ejb.easybeans.PrefixedNamingStrategy;
import org.ow2.jonas.lib.loader.FilteringClassLoader;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

public class EasyBeansDeployer
extends AbsDeployer<EJB3Deployable> {
    private Log logger = LogFactory.getLog(EasyBeansDeployer.class);
    private Embedded easybeansServer = null;
    private ClassLoader appsClassLoader;
    private Map<URL, EJB3Deployable> ejb3s = new HashMap<URL, EJB3Deployable>();
    private ServerProperties serverProperties = null;
    private VersioningService versioningService;
    private DeployerLog deployerLog;
    private String workDirectory = null;

    /*
     * Unable to fully structure code
     */
    public void doDeploy(IDeployable<EJB3Deployable> deployable) throws DeployerException {
        unpackedDeployable = null;
        initialURL = null;
        initialFile = null;
        deployableInfo = (EZBDeployableInfo)deployable.getExtension(EasyBeansDeployableInfo.class);
        unpack = true;
        ejb3ClassLoader = null;
        applicationJNDIResolver = null;
        if (deployableInfo != null) {
            if (deployableInfo.hasToBeUnpacked() != null) {
                unpack = deployableInfo.hasToBeUnpacked();
            }
            ejb3ClassLoader = deployableInfo.getClassLoader();
            applicationJNDIResolver = deployableInfo.getApplicationJNDIResolver();
        }
        if (unpack) {
            folder = new File(this.workDirectory, this.getServerProperties().getServerName());
            folder.mkdirs();
            try {
                initialURL = deployable.getArchive().getURL();
                initialFile = URLUtils.urlToFile((URL)initialURL);
                unpackedDeployable = (EJB3Deployable)UnpackDeployableHelper.unpack((IDeployable)((IDeployable)EJB3Deployable.class.cast(deployable)), (File)folder, (String)FileUtils.lastModifiedFileName((File)initialFile));
            }
            catch (ArchiveException e) {
                throw new DeployerException("Cannot get archive while deploying EJB3Deployable", (Throwable)e);
            }
            catch (FileUtilsException e) {
                throw new DeployerException("Cannot get file last modified date while deploying EJB3Deployable", (Throwable)e);
            }
            try {
                if (this.deployerLog == null) ** GOTO lbl35
                unpackedFile = URLUtils.urlToFile((URL)unpackedDeployable.getArchive().getURL());
                this.deployerLog.addEntry(initialFile, unpackedFile);
            }
            catch (Exception e) {
                throw new DeployerException("Cannot get  the url of the initial deployable for the EJB3 Module '" + deployable + "'.", (Throwable)e);
            }
        } else {
            unpackedDeployable = (EJB3Deployable)deployable;
        }
lbl35:
        // 3 sources

        this.logger.info((Object)"Deploying ''{0}''...", new Object[]{deployable.getShortName()});
        container = this.easybeansServer.createContainer((IDeployable)unpackedDeployable);
        prefix = null;
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            prefix = this.versioningService.getPrefix(deployable);
        }
        if (prefix != null) {
            namingStrategies = container.getConfiguration().getNamingStrategies();
            this.logger.info((Object)"Naming Strategies = ''{0}''", new Object[]{namingStrategies});
            newNamingStrategies = new ArrayList<PrefixedNamingStrategy>();
            for (EZBNamingStrategy oldNamingStrategy : namingStrategies) {
                newNamingStrategies.add(new PrefixedNamingStrategy(prefix, oldNamingStrategy));
            }
            container.getConfiguration().setNamingStrategies(newNamingStrategies);
        }
        arrayURLs = new URL[]{this.getURL((IDeployable)unpackedDeployable)};
        if (ejb3ClassLoader == null) {
            filteringClassLoader = this.createFilteringClassLoader(deployable);
            ejb3ClassLoader = new EasyBeansClassLoader(arrayURLs, (ClassLoader)filteringClassLoader);
        }
        container.setClassLoader(ejb3ClassLoader);
        if (applicationJNDIResolver != null) {
            containerJNDIResolver = container.getConfiguration().getContainerJNDIResolver();
            containerJNDIResolver.setApplicationJNDIResolver(applicationJNDIResolver);
            applicationJNDIResolver.addContainerJNDIResolver(containerJNDIResolver);
        }
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.easybeansServer.removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + deployable + "'.", (Throwable)e);
        }
        this.ejb3s.put(initialURL, unpackedDeployable);
        if (prefix != null) {
            this.versioningService.createJNDIBindingMBeans(deployable);
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now deployed", new Object[]{deployable.getShortName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilteringClassLoader createFilteringClassLoader(IDeployable<?> deployable) {
        FilteringClassLoader filteringClassLoader = new FilteringClassLoader(this.appsClassLoader);
        IArchive archive = deployable.getArchive();
        try {
            String name = "META-INF/classloader-filtering.xml";
            URL resource = archive.getResource(name);
            if (resource != null) {
                filteringClassLoader.setDefinitionUrl(resource);
            }
        }
        catch (ArchiveException ae) {
            this.logger.debug((Object)"Cannot get classloader-filtering.xml file from the EJB3 archive {0}.", new Object[]{archive, ae});
        }
        finally {
            archive.close();
        }
        filteringClassLoader.start();
        return filteringClassLoader;
    }

    public void doUndeploy(IDeployable<EJB3Deployable> deployable) throws DeployerException {
        URL initialURL = null;
        try {
            initialURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL of the EJB3 deployable '" + deployable + "'.", (Throwable)e);
        }
        IArchive archive = null;
        if (!this.ejb3s.containsKey(initialURL)) {
            throw new DeployerException("Cannot get the URL of the unpacked EJB3 deployable '" + deployable + "'.");
        }
        archive = this.ejb3s.get(initialURL).getArchive();
        this.logger.info((Object)"Undeploying ''{0}''...", new Object[]{deployable.getShortName()});
        Map containers = this.easybeansServer.getContainers();
        EZBContainer foundContainer = null;
        for (EZBContainer container : containers.values()) {
            IArchive containerArchive = container.getArchive();
            if (!archive.equals(containerArchive)) continue;
            foundContainer = container;
            break;
        }
        if (foundContainer == null) {
            throw new DeployerException("Cannot undeploy the deployable '" + deployable + "' as this container is not deployed");
        }
        this.ejb3s.remove(initialURL);
        this.logger.debug((Object)"Found a matching container ''{0}'' for the archive ''{1}''", new Object[]{foundContainer, deployable.getArchive()});
        try {
            foundContainer.stop();
            this.easybeansServer.removeContainer(foundContainer);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployable '" + deployable + "'", (Throwable)e);
        }
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            this.versioningService.garbageCollectJNDIBindingMBeans();
        }
        this.logger.info((Object)"''{0}'' EJB3 Deployable is now undeployed", new Object[]{deployable.getShortName()});
    }

    public boolean supports(IDeployable<?> deployable) {
        return EJB3Deployable.class.isInstance(deployable);
    }

    public Map<URL, EJB3Deployable> getEJB3s() {
        return this.ejb3s;
    }

    public void setEmbedded(Embedded easybeansServer) {
        this.easybeansServer = easybeansServer;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setDeployerLog(DeployerLog deployerLog) {
        this.deployerLog = deployerLog;
    }

    public void setAppsClassLoader(ClassLoader appsClassLoader) {
        this.appsClassLoader = appsClassLoader;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }
}

