/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class PreparedStatementWrapper
implements PreparedStatement {
    private static final int[] PRIME_NUMBERS = new int[]{11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47};
    private PreparedStatement pstmt = null;
    private String user = null;
    private String sql = null;
    private boolean invalid = false;
    private boolean closed = false;
    private int hashCode;
    private int resultSetType = -1;
    private int resultSetConcurrency = -1;
    private int resultSetHoldability = -1;
    private int autoGeneratedKeys = -1;
    private int[] columnIndexes = null;
    private String[] columnNames = null;
    private final Logger trace;
    private boolean setFetchDirectionCalled = false;
    private boolean setEscapeProcessingCalled = false;
    private boolean setMaxFieldSizeCalled = false;
    private final boolean isDebugLogging;

    private PreparedStatementWrapper(String user, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames, Logger trace, boolean isDebugLogging) {
        this.user = user;
        this.sql = sql;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.autoGeneratedKeys = autoGeneratedKeys;
        this.columnIndexes = columnIndexes;
        this.columnNames = columnNames;
        this.trace = trace;
        int i = 0;
        this.hashCode = sql != null ? sql.hashCode() : PRIME_NUMBERS[i++];
        this.hashCode = user != null ? (this.hashCode ^= user.hashCode()) : (this.hashCode ^= PRIME_NUMBERS[i++]);
        this.hashCode ^= resultSetType * PRIME_NUMBERS[i++];
        this.hashCode ^= resultSetConcurrency * PRIME_NUMBERS[i++];
        this.hashCode ^= resultSetHoldability * PRIME_NUMBERS[i++];
        this.hashCode ^= autoGeneratedKeys * PRIME_NUMBERS[i++];
        this.hashCode = columnIndexes != null ? (this.hashCode ^= columnIndexes.hashCode()) : (this.hashCode ^= PRIME_NUMBERS[i++]);
        this.hashCode = columnNames != null ? (this.hashCode ^= columnNames.hashCode()) : (this.hashCode ^= PRIME_NUMBERS[i++]);
        this.isDebugLogging = isDebugLogging;
    }

    public PreparedStatementWrapper(String user, String sql, int resultSetType, int resultSetConcurrency, Logger trace, boolean isDebugLogging) {
        this(user, sql, resultSetType, resultSetConcurrency, -1, -1, null, null, trace, isDebugLogging);
    }

    public PreparedStatementWrapper(String user, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability, Logger trace, boolean isDebugLogging) {
        this(user, sql, resultSetType, resultSetConcurrency, resultSetHoldability, -1, null, null, trace, isDebugLogging);
    }

    public PreparedStatementWrapper(String user, String sql, int autoGeneratedKeys, Logger trace, boolean isDebugLogging) {
        this(user, sql, -1, -1, -1, autoGeneratedKeys, null, null, trace, isDebugLogging);
    }

    public PreparedStatementWrapper(String user, String sql, int[] columnIndexes, Logger trace, boolean isDebugLogging) {
        this(user, sql, -1, -1, -1, -1, columnIndexes, null, trace, isDebugLogging);
    }

    public PreparedStatementWrapper(String user, String sql, String[] columnNames, Logger trace, boolean isDebugLogging) {
        this(user, sql, -1, -1, -1, -1, null, columnNames, trace, isDebugLogging);
    }

    public void checkIfValid() throws SQLException {
        if (this.invalid) {
            SQLException se = new SQLException("PreparedStatement(" + this + ") is invalid.");
            this.trace.log(BasicLevel.ERROR, (Object)se);
            throw se;
        }
    }

    public void clearPstmtValues() {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    this.closed = false;
                                    try {
                                        this.pstmt.clearParameters();
                                        this.pstmt.clearBatch();
                                    }
                                    catch (Throwable ex) {
                                        if (!this.isDebugLogging) break block17;
                                        this.trace.log(BasicLevel.DEBUG, (Object)"Cannot clear parameters", ex);
                                    }
                                }
                                if (this.setEscapeProcessingCalled) {
                                    try {
                                        this.pstmt.setEscapeProcessing(true);
                                    }
                                    catch (Throwable ex) {
                                        if (!this.isDebugLogging) break block18;
                                        this.trace.log(BasicLevel.DEBUG, (Object)"Cannot reset escape processing to true", ex);
                                    }
                                }
                            }
                            if (this.setFetchDirectionCalled) {
                                try {
                                    this.pstmt.setFetchDirection(1000);
                                }
                                catch (Throwable ex) {
                                    if (!this.isDebugLogging) break block19;
                                    this.trace.log(BasicLevel.DEBUG, (Object)"Cannot set fetch direction to ResultSet.FETCH_FORWARD", ex);
                                }
                            }
                        }
                        if (this.setMaxFieldSizeCalled) {
                            try {
                                this.pstmt.setMaxFieldSize(0);
                            }
                            catch (Throwable ex) {
                                if (!this.isDebugLogging) break block20;
                                this.trace.log(BasicLevel.DEBUG, (Object)"Cannot set max field size to 0", ex);
                            }
                        }
                    }
                    try {
                        this.pstmt.setMaxRows(0);
                    }
                    catch (Throwable ex) {
                        if (!this.isDebugLogging) break block21;
                        this.trace.log(BasicLevel.DEBUG, (Object)"Cannot set max rows to 0", ex);
                    }
                }
                try {
                    this.pstmt.setQueryTimeout(0);
                }
                catch (Throwable ex) {
                    if (!this.isDebugLogging) break block22;
                    this.trace.log(BasicLevel.DEBUG, (Object)"Cannot set query timeout to 0", ex);
                }
            }
            try {
                this.pstmt.clearWarnings();
            }
            catch (Throwable ex) {
                if (!this.isDebugLogging) break block23;
                this.trace.log(BasicLevel.DEBUG, (Object)"Cannot clear warnings", ex);
            }
        }
    }

    public void closePstmt() throws SQLException {
        this.closed = true;
        this.pstmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws SQLException {
        if (this.isDebugLogging) {
            this.trace.log(BasicLevel.DEBUG, (Object)("" + this));
        }
        try {
            this.pstmt.close();
        }
        finally {
            this.invalid = true;
            this.closed = true;
        }
    }

    public boolean equals(Object stmt) {
        if (stmt == null) {
            return false;
        }
        if (this.hashCode != stmt.hashCode()) {
            return false;
        }
        if (!(stmt instanceof PreparedStatementWrapper)) {
            return false;
        }
        PreparedStatementWrapper psw = (PreparedStatementWrapper)stmt;
        if (this.invalid) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)"Prepared Statement is invalid");
            }
            return false;
        }
        if (this.sql == null && psw.sql != null) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt sql: " + psw.sql + " not equal to " + this.sql));
            }
            return false;
        }
        if (this.sql != null && !this.sql.equals(psw.sql)) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt sql: " + psw.sql + " not equal to " + this.sql));
            }
            return false;
        }
        if (this.user == null && psw.user != null) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt user: " + psw.user + " not equal to " + this.user));
            }
            return false;
        }
        if (this.user != null && !this.user.equals(psw.user)) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt user: " + psw.user + " not equal to " + this.user));
            }
            return false;
        }
        if (this.resultSetType != psw.resultSetType) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt resultSetType: " + psw.resultSetType + " not equal to " + this.resultSetType));
            }
            return false;
        }
        if (this.resultSetConcurrency != psw.resultSetConcurrency) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt resultSetConcurrency: " + psw.resultSetConcurrency + " not equal to " + this.resultSetConcurrency));
            }
            return false;
        }
        if (this.resultSetHoldability != psw.resultSetHoldability) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt resultSetHoldability: " + psw.resultSetHoldability + " not equal to " + this.resultSetHoldability));
            }
            return false;
        }
        if (this.autoGeneratedKeys != psw.autoGeneratedKeys) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt autoGeneratedKeys: " + psw.autoGeneratedKeys + " not equal to " + this.autoGeneratedKeys));
            }
            return false;
        }
        if (!Arrays.equals(this.columnIndexes, psw.columnIndexes)) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt columnIndexes: " + psw.columnIndexes + " not equal to " + this.columnIndexes));
            }
            return false;
        }
        if (!Arrays.equals(this.columnNames, psw.columnNames)) {
            if (this.isDebugLogging) {
                this.trace.log(BasicLevel.DEBUG, (Object)("Stmt columnNames: " + psw.columnNames + " not equal to " + this.columnNames));
            }
            return false;
        }
        if (this.isDebugLogging) {
            this.trace.log(BasicLevel.DEBUG, (Object)("Stmt found at " + this));
        }
        return true;
    }

    public void setClosed(boolean val) {
        this.closed = val;
    }

    public void setPreparedStatement(PreparedStatement pstmt) {
        this.pstmt = pstmt;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkIfValid();
        this.pstmt.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkIfValid();
        this.pstmt.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkIfValid();
        return this.pstmt.execute();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfValid();
        return this.pstmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfValid();
        return this.pstmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkIfValid();
        return this.pstmt.execute(sql, columnNames);
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeQuery();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeUpdate();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeUpdate(sql, columnNames);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getGeneratedKeys();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getMetaData();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkIfValid();
        return this.pstmt.getMoreResults(current);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getParameterMetaData();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getResultSetHoldability();
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setArray(i, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBlob(i, x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBytes(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setClob(i, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setDate(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkIfValid();
        this.pstmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setDouble(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setFloat(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setLong(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkIfValid();
        this.pstmt.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.checkIfValid();
        this.pstmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setRef(i, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setShort(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setString(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setTime(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkIfValid();
        this.pstmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkIfValid();
        this.pstmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void addBatch(String s) throws SQLException {
        this.checkIfValid();
        this.pstmt.addBatch(s);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkIfValid();
        this.pstmt.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkIfValid();
        this.pstmt.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkIfValid();
        this.pstmt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        if (this.isDebugLogging) {
            this.trace.log(BasicLevel.DEBUG, (Object)("" + this));
        }
        this.closed = true;
    }

    @Override
    public boolean execute(String s) throws SQLException {
        this.checkIfValid();
        return this.pstmt.execute(s);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeBatch();
    }

    @Override
    public ResultSet executeQuery(String s) throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeQuery(s);
    }

    @Override
    public int executeUpdate(String s) throws SQLException {
        this.checkIfValid();
        return this.pstmt.executeUpdate(s);
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getFetchSize();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getMoreResults();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkIfValid();
        return this.pstmt.getWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkIfValid();
        this.pstmt.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkIfValid();
        this.setEscapeProcessingCalled = true;
        this.pstmt.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkIfValid();
        this.setFetchDirectionCalled = true;
        this.pstmt.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkIfValid();
        this.pstmt.setFetchSize(rows);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.checkIfValid();
        this.setMaxFieldSizeCalled = true;
        this.pstmt.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkIfValid();
        this.pstmt.setMaxRows(max);
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkIfValid();
        this.pstmt.setQueryTimeout(seconds);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setURL(parameterIndex, x);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setRowId(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.checkIfValid();
        this.pstmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkIfValid();
        this.pstmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkIfValid();
        this.pstmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIfValid();
        this.pstmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkIfValid();
        this.pstmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkIfValid();
        this.pstmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.checkIfValid();
        this.pstmt.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        this.checkIfValid();
        return this.pstmt.isPoolable();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkIfValid();
        return this.pstmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkIfValid();
        return this.pstmt.unwrap(iface);
    }

    public String getSql() {
        return this.sql;
    }

    public String getUser() {
        return this.user;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public int getOriginalResultSetType() {
        return this.resultSetType;
    }

    public int getOriginalResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getOriginalResultSetHoldability() {
        return this.resultSetHoldability;
    }
}

