/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.resource.internal.cm.sql.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.resource.internal.cm.sql.PreparedStatementWrapper;
import org.ow2.jonas.resource.internal.cm.sql.cache.AbstractPreparedStatementCacheImpl;
import org.ow2.jonas.resource.internal.cm.sql.cache.CacheException;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCache;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementCacheStatistics;
import org.ow2.jonas.resource.internal.cm.sql.cache.PreparedStatementMapCacheKey;

public class PreparedStatementMapCacheImpl
extends AbstractPreparedStatementCacheImpl
implements PreparedStatementCache {
    public Map<PreparedStatementMapCacheKey, List<PreparedStatementWrapper>> pStmts = null;

    public PreparedStatementMapCacheImpl(int maxCacheSize, PreparedStatementCacheStatistics pstmtStats, Logger logger) {
        super(maxCacheSize, pstmtStats, logger);
        this.pStmts = maxCacheSize > 0 ? Collections.synchronizedMap(new LinkedHashMap<PreparedStatementMapCacheKey, List<PreparedStatementWrapper>>(maxCacheSize){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<PreparedStatementMapCacheKey, List<PreparedStatementWrapper>> eldest) {
                return false;
            }
        }) : Collections.synchronizedMap(new LinkedHashMap<PreparedStatementMapCacheKey, List<PreparedStatementWrapper>>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<PreparedStatementMapCacheKey, List<PreparedStatementWrapper>> eldest) {
                return false;
            }
        });
    }

    @Override
    public synchronized PreparedStatementWrapper get(PreparedStatementWrapper psw) {
        int jumpNb = 0;
        int found = 0;
        PreparedStatementWrapper outputPsw2 = null;
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)("MC pStmts: " + this.pStmts));
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementMapCacheKey key = this.getPstmtKey(psw);
        List<PreparedStatementWrapper> listPsw = this.pStmts.get(key);
        if (listPsw != null) {
            for (PreparedStatementWrapper outputPsw2 : listPsw) {
                if (outputPsw2.isClosed()) {
                    outputPsw2.clearPstmtValues();
                    ++found;
                    break;
                }
                outputPsw2 = null;
                ++jumpNb;
                if (!cacheLogger.isLoggable(BasicLevel.DEBUG)) continue;
                cacheLogger.log(BasicLevel.DEBUG, (Object)"Statement in cache but already used, search another one");
                cacheLogger.log(BasicLevel.DEBUG, (Object)("sql=" + psw.getSql() + ", count=" + jumpNb));
            }
        }
        if (found > 0) {
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)("Statement found in cache " + outputPsw2));
            }
            this.stats.incrementPrepStmtCacheHitCount();
        } else {
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)"No statement in cache (or not closed)");
            }
            this.stats.incrementPrepStmtCacheMissCount();
        }
        return outputPsw2;
    }

    @Override
    public synchronized void put(PreparedStatementWrapper psw) throws CacheException, SQLException {
        if (this.maxPstmtCacheSize < 0) {
            throw new CacheException("Cache disabled");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        if (this.pstmtCacheSize >= this.maxPstmtCacheSize && this.maxPstmtCacheSize != 0 && !this.findFree()) {
            if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                cacheLogger.log(BasicLevel.DEBUG, (Object)"No more space in cache");
            }
            throw new CacheException("No more space in cache");
        }
        PreparedStatementMapCacheKey key = this.getPstmtKey(psw);
        List<PreparedStatementWrapper> listPsw = this.pStmts.get(key);
        if (listPsw == null) {
            listPsw = new ArrayList<PreparedStatementWrapper>();
            this.pStmts.put(key, listPsw);
        }
        ++this.pstmtCacheSize;
        listPsw.add(psw);
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)("Adding PStmt: " + psw));
        }
        this.stats.incrementPrepStmtCacheAddCount();
        this.stats.incrementPrepStmtCacheCurrentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getState(String prefix) {
        String res = "";
        PreparedStatementMapCacheImpl preparedStatementMapCacheImpl = this;
        synchronized (preparedStatementMapCacheImpl) {
            res = res + prefix + "size of pStmts:" + this.pstmtCacheSize + "\n";
            for (List<PreparedStatementWrapper> list : this.pStmts.values()) {
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    res = res + prefix + "\t" + list.get(i) + "\n";
                }
            }
        }
        return res;
    }

    @Override
    public synchronized void destroy() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Destroy the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        for (List<PreparedStatementWrapper> list : this.pStmts.values()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                pw = list.get(i);
                try {
                    pw.destroy();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.stats.incrementPrepStmtCacheDeleteCount();
                this.stats.decrementPrepStmtCacheCurrentSize();
            }
            list.clear();
        }
        this.pStmts.clear();
        this.pstmtCacheSize = 0;
    }

    @Override
    public synchronized void reallyClose() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Close physically the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        for (List<PreparedStatementWrapper> list : this.pStmts.values()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                pw = list.get(i);
                try {
                    pw.closePstmt();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.stats.incrementPrepStmtCacheDeleteCount();
                this.stats.decrementPrepStmtCacheCurrentSize();
            }
            list.clear();
        }
        this.pStmts.clear();
        this.pstmtCacheSize = 0;
    }

    @Override
    public synchronized void close() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Close the cache entries");
        }
        this.stats.incrementPrepStmtCacheAccessCount();
        PreparedStatementWrapper pw = null;
        for (List<PreparedStatementWrapper> list : this.pStmts.values()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                pw = list.get(i);
                try {
                    pw.close();
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private boolean findFree() {
        if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
            cacheLogger.log(BasicLevel.DEBUG, (Object)"Close the first entry");
        }
        PreparedStatementWrapper pw = null;
        for (List<PreparedStatementWrapper> list : this.pStmts.values()) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                pw = list.get(i);
                if (!pw.isClosed()) continue;
                if (cacheLogger.isLoggable(BasicLevel.DEBUG)) {
                    cacheLogger.log(BasicLevel.DEBUG, (Object)("removes " + pw));
                }
                list.remove(i);
                --this.pstmtCacheSize;
                this.stats.incrementPrepStmtCacheDeleteCount();
                this.stats.decrementPrepStmtCacheCurrentSize();
                return true;
            }
        }
        return false;
    }

    private PreparedStatementMapCacheKey getPstmtKey(PreparedStatementWrapper psw) {
        PreparedStatementMapCacheKey key = null;
        key = new PreparedStatementMapCacheKey(psw.getUser(), psw.getSql(), psw.getOriginalResultSetType(), psw.getOriginalResultSetConcurrency(), psw.getOriginalResultSetHoldability(), psw.getAutoGeneratedKeys(), psw.getColumnIndexes(), psw.getColumnNames(), psw.hashCode(), cacheLogger);
        return key;
    }
}

