/*
 * Decompiled with CFR 0.152.
 */
package javax.jms;

import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class TopicRequestor {
    private TopicSession session;
    private TemporaryTopic temporaryTopic;
    private TopicPublisher publisher;
    private TopicSubscriber subscriber;

    public TopicRequestor(TopicSession session, Topic topic) throws JMSException {
        if (topic == null) {
            throw new InvalidDestinationException("Invalid topic");
        }
        this.session = session;
        this.temporaryTopic = session.createTemporaryTopic();
        this.publisher = session.createPublisher(topic);
        this.subscriber = session.createSubscriber(this.temporaryTopic);
    }

    public Message request(Message message) throws JMSException {
        message.setJMSReplyTo(this.temporaryTopic);
        this.publisher.publish(message);
        return this.subscriber.receive();
    }

    public void close() throws JMSException {
        this.session.close();
        this.temporaryTopic.delete();
    }
}

