/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.axis.wsdl2java;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.wsdl.WSDL2Java;
import org.apache.axis.wsdl.gen.Parser;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.generator.axis.AxisWsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.axis.wsdl2java.JOnASEmitter;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JOnASWSDL2Java
extends WSDL2Java {
    private JOnASEmitter jEmitter = (JOnASEmitter)this.getParser();
    private String wsdlURL = null;
    private Document wsdlDoc = null;

    protected Parser createParser() {
        return new JOnASEmitter();
    }

    private void setup(AxisWsClientGenerator wsc) throws WsGenException {
        this.setupEmitter(wsc);
        this.setupWSDL(wsc);
    }

    private void setupWSDL(AxisWsClientGenerator wsc) throws WsGenException {
        try {
            if (wsc.getArchive().isPacked()) {
                String jarpath = wsc.getArchive().getRootFile().getCanonicalFile().toURL().toExternalForm();
                this.wsdlURL = "jar:" + jarpath + "!/" + wsc.getRef().getWsdlFileName();
            } else {
                this.wsdlURL = new File(wsc.getArchive().getRootFile(), wsc.getRef().getWsdlFileName()).toURL().toExternalForm();
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.wsdlDoc = builder.parse(this.wsdlURL);
        }
        catch (ParserConfigurationException pce) {
            throw new WsGenException("", pce);
        }
        catch (IOException ioe) {
            throw new WsGenException("", ioe);
        }
        catch (SAXException se) {
            throw new WsGenException("", se);
        }
    }

    private void setupEmitter(AxisWsClientGenerator wsc) {
        this.jEmitter.setDebug(wsc.getConfig().isDebug());
        this.jEmitter.setVerbose(wsc.getConfig().isVerbose());
        this.jEmitter.setNamespaceMap(this.convert2HashMap(wsc.getRef().getMappingFile().getMappings()));
        this.jEmitter.setOutputDir(wsc.getSources().getPath());
    }

    private HashMap convert2HashMap(Map m) {
        HashMap ns2pkg = new HashMap();
        for (String ns : m.keySet()) {
            ns2pkg.put(ns, m.get(ns));
        }
        return ns2pkg;
    }

    public void run(AxisWsClientGenerator wsc) throws WsGenException, IOException, SAXException, WSDLException, ParserConfigurationException {
        this.setup(wsc);
        this.parser.run(this.wsdlURL, this.wsdlDoc);
    }
}

