/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.generator.ews;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.constants.Scope;
import org.apache.axis.wsdl.toJava.GeneratedFileInfo;
import org.apache.ws.ews.mapper.context.JAXRPCMapperContext;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.deployment.ws.JaxRpcPortComponentDesc;
import org.ow2.jonas.deployment.ws.PortComponentDesc;
import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.generators.genbase.GenBaseException;
import org.ow2.jonas.generators.genbase.archive.Archive;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.genbase.archive.WebApp;
import org.ow2.jonas.generators.genbase.generator.Config;
import org.ow2.jonas.generators.wsgen.WsGenException;
import org.ow2.jonas.generators.wsgen.ddmodifier.WebServicesDDModifier;
import org.ow2.jonas.generators.wsgen.ddmodifier.WsEndpointDDModifier;
import org.ow2.jonas.generators.wsgen.generator.WsEndpointGenerator;
import org.ow2.jonas.generators.wsgen.generator.ews.EWSWsClientGenerator;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.JOnASJ2EEWebServicesContext;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.emitter.FullEmitter;
import org.ow2.jonas.generators.wsgen.generator.ews.wsdltoj2ee.factory.JOnASEndpointGeneratorFactory;
import org.ow2.jonas.lib.loader.AbsModuleClassLoader;
import org.ow2.jonas.lib.util.I18n;
import org.ow2.jonas.lib.util.Log;
import org.w3c.dom.NodeList;

public class EWSWsEndpointGenerator
extends WsEndpointGenerator {
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.generators.wsgen.ews");
    private static final String AXIS_SERVLET_CLASS = "org.ow2.jonas.ws.axis.JAxisServlet";
    private static final String SERVER_CONFIG = "axis.serverConfigFile";
    private File generatedServerConfig;
    private static I18n i18n = I18n.getInstance(EWSWsClientGenerator.class);

    public EWSWsEndpointGenerator(Config config, ServiceDesc serviceDesc, WsEndpointDDModifier ddm, WebServicesDDModifier wsddm, Archive arch) throws GenBaseException {
        super(config, serviceDesc, ddm, wsddm, arch);
    }

    @Override
    public void generate() throws WsGenException {
        String filename = null;
        try {
            FullEmitter emitter = new FullEmitter();
            emitter.setWscontext(this.prepareJ2EEWebServicesContext(this.getService()));
            emitter.setMappingFileInputStream(this.getService().getMappingFileURL().openStream());
            emitter.setOutputDir(this.getSources().getCanonicalPath());
            JOnASEndpointGeneratorFactory factory = new JOnASEndpointGeneratorFactory();
            factory.setEmitter(emitter);
            emitter.setFactory(factory);
            emitter.setTypeMappingVersion("1.3");
            emitter.setScope(Scope.REQUEST);
            emitter.setWrapArrays(true);
            emitter.setServerSide(true);
            emitter.run(this.getService().getLocalWSDLURL().toExternalForm());
            this.generatedServerConfig = new File(EWSWsEndpointGenerator.findServerConfigFile(emitter.getGeneratedFileInfo()));
            filename = this.generatedServerConfig.getName();
            EWSWsEndpointGenerator.getLogger().log(BasicLevel.INFO, (Object)("Webservice endpoint WSDD file '" + filename + "' sucessfully generated by EWS."));
        }
        catch (Exception e) {
            String err = i18n.getMessage("EWSWsEndpointGenerator.generate.WSDL2Java", (Object)this.getService().getName(), (Object)e.getMessage());
            logger.log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new WsGenException(err, e);
        }
        J2EEArchive j2eeArchive = (J2EEArchive)this.getArchive();
        AbsModuleClassLoader cl = (AbsModuleClassLoader)j2eeArchive.getModuleClassloader();
        this.getConfig().setClasspath(this.getConfig().getClasspath() + cl.getClasspath());
        for (PortComponentDesc desc : this.getService().getPortComponents()) {
            String urlPatternOld = null;
            NodeList securityRoleRefs = null;
            if (desc.hasJaxRpcImpl()) {
                JaxRpcPortComponentDesc jax = (JaxRpcPortComponentDesc)desc;
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Removing servlet '" + jax.getSibLink() + "'"));
                }
                urlPatternOld = this.getModifier().removeServletMapping(jax.getSibLink());
                securityRoleRefs = this.getModifier().removeServletWithSecurity(jax.getSibLink());
            }
            this.getModifier().addServlet(desc.getSibLink(), AXIS_SERVLET_CLASS);
            this.getModifier().addServletParam(desc.getSibLink(), SERVER_CONFIG, filename);
            this.getModifier().addServletParam(desc.getSibLink(), "axis.development.system", "true");
            String mapping = null;
            mapping = desc.getEndpointURI() != null ? desc.getEndpointURI() : "/" + desc.getName() + "/*";
            this.getModifier().addServletMapping(desc.getSibLink(), mapping);
            if (!desc.hasJaxRpcImpl()) continue;
            if (securityRoleRefs != null) {
                this.getModifier().addServletSecurityRoleRefs(desc.getSibLink(), securityRoleRefs);
            }
            this.getModifier().updateSecurityConstraint(urlPatternOld, mapping);
        }
    }

    private static String findServerConfigFile(GeneratedFileInfo generatedFileInfo) {
        List generated = generatedFileInfo.getFileNames();
        boolean found = false;
        String filename = null;
        Iterator i = generated.iterator();
        while (i.hasNext() && !found) {
            String entry = (String)i.next();
            if (!entry.matches(".*deploy-server-\\d+\\.wsdd$")) continue;
            found = true;
            filename = entry;
        }
        return filename;
    }

    private JAXRPCMapperContext prepareJ2EEWebServicesContext(ServiceDesc service) {
        JOnASJ2EEWebServicesContext ctx = new JOnASJ2EEWebServicesContext();
        ctx.setServiceDesc(service);
        return ctx;
    }

    public void addFiles(Archive archive) throws WsGenException {
        if (!(archive instanceof WebApp)) {
            String err = EWSWsEndpointGenerator.getI18n().getMessage("AxisWsEndpointGenerator.addFiles.illegal", (Object)archive.getRootFile());
            throw new IllegalArgumentException(err);
        }
        WebApp web = (WebApp)archive;
        web.addFileIn("WEB-INF/", this.generatedServerConfig);
        web.addDirectoryIn("WEB-INF/classes/", this.getClasses());
        web.addDirectoryIn("WEB-INF/sources/", this.getSources());
    }
}

