/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import java.io.CharArrayReader;
import java.lang.reflect.Method;
import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.ejb.BeanDesc;
import org.ow2.jonas.deployment.ejb.EntityDesc;
import org.ow2.jonas.deployment.ejb.MethodDesc;
import org.ow2.jonas.deployment.ejb.ejbql.ASTEJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.EJBQL;
import org.ow2.jonas.deployment.ejb.ejbql.ParseException;
import org.ow2.jonas.deployment.ejb.xml.QueryMethod;

public class MethodCmp2Desc
extends MethodDesc {
    protected String query = null;
    protected ASTEJBQL queryNode = null;
    protected boolean resultTypeMappingRemote = false;
    protected EntityDesc entityDesc;

    MethodCmp2Desc(BeanDesc beanDesc, Method meth, Class classDef, int index) {
        super(beanDesc, meth, classDef, index);
        this.entityDesc = (EntityDesc)beanDesc;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) throws ParseException {
        this.query = query.replace('\r', ' ').replace('\n', ' ').replace('\t', ' ');
        EJBQL parser = new EJBQL(new CharArrayReader(query.toCharArray()));
        this.queryNode = (ASTEJBQL)parser.EJBQL();
    }

    public ASTEJBQL getQueryNode() {
        return this.queryNode;
    }

    public boolean isResultTypeMappingRemote() {
        return this.resultTypeMappingRemote;
    }

    public void setResultTypeMapping(String resultTypeMapping) throws DeploymentDescException {
        if (resultTypeMapping.equals("Remote")) {
            this.resultTypeMappingRemote = true;
        } else if (resultTypeMapping.equals("Local")) {
            this.resultTypeMappingRemote = false;
        } else {
            throw new DeploymentDescException(resultTypeMapping + " is not a valid result-type-mapping value");
        }
    }

    public boolean getPrefetch() {
        if (this.isFinder()) {
            return this.entityDesc.isPrefetch();
        }
        return false;
    }

    public static String queryMethodElementToString(QueryMethod m) {
        return MethodCmp2Desc.methodElementToString(null, m.getMethodName(), m.getMethodParams());
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\nquery = " + this.query);
        ret.append("\nqueryNode = " + this.queryNode);
        ret.append("\nresultTypeMappingRemote = " + this.resultTypeMappingRemote);
        return ret.toString();
    }
}

