/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.audit.internal.logger.pool;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.audit.internal.logger.util.LogConfigurator;

public abstract class FileLogPool {
    private File mainDir;
    private String mainPath;
    private FilenameFilter filter;
    private Pattern pattern;
    private String beginFP;
    private String endFP;
    private String logFilename = null;
    private String logFilenamePattern = null;
    private LogConfigurator lc = null;
    private Logger logger = null;
    private boolean fileLogger;
    private int numberFiles = 0;
    private int maxFiles = -1;
    private static final String FILE_HANDLER_NAME = "fileLogPoolHandler";
    private static final String CONSOLE_HANDLER_NAME = "consoleLogPoolHandler";
    private static final String LOGGER_LEVEL = "INFO";
    public static final int UNLIMITED = -1;
    private static final int PATTERN_GROUP = 1;

    public FileLogPool(String dirPath, String className, String fixedPattern, String variablePattern, int positionVariablePattern, String msgPattern, int maxFiles, boolean fileLogger, boolean consoleLogger) throws IOException {
        this.mainDir = new File(dirPath);
        if (this.mainDir.isFile()) {
            throw new IOException("Path of the file pool is not valid.");
        }
        if (!this.mainDir.exists()) {
            this.mainDir.mkdirs();
        }
        this.fileLogger = fileLogger;
        this.beginFP = fixedPattern.substring(0, positionVariablePattern);
        this.endFP = fixedPattern.substring(positionVariablePattern);
        StringBuilder builder = new StringBuilder(this.beginFP);
        builder.append('(');
        builder.append(variablePattern);
        builder.append(')');
        builder.append(this.endFP);
        this.pattern = Pattern.compile(builder.toString());
        this.filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher m = FileLogPool.this.pattern.matcher(name);
                return m.matches();
            }
        };
        this.mainPath = this.mainDir.getCanonicalPath() + File.separator;
        this.logFilenamePattern = this.initLogFilenamePattern();
        builder = new StringBuilder(this.beginFP);
        builder.append(this.logFilenamePattern);
        builder.append(this.endFP);
        this.logFilename = builder.toString();
        this.setMaxFiles(maxFiles);
        if (consoleLogger || fileLogger) {
            this.lc = new LogConfigurator(className, this.getLoggerLevel(), false);
            if (fileLogger) {
                this.lc.setSimpleFileHandler(this.getFileHandlerName(), this.mainPath + this.logFilename, msgPattern, null, true);
            }
            if (consoleLogger) {
                this.lc.setConsoleHandler(this.getConsoleHandlerName(), 0, msgPattern, null);
            }
            this.logger = this.lc.apply();
        }
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        this.listLogFilenames();
    }

    private void updateFileNumber(Object[] logFiles) {
        block3: {
            int totalDeleted;
            block4: {
                this.numberFiles = logFiles.length;
                if (this.maxFiles <= 0 || this.maxFiles >= this.numberFiles) break block3;
                totalDeleted = this.numberFiles - this.maxFiles;
                this.numberFiles = this.maxFiles;
                if (!(logFiles instanceof String[])) break block4;
                int i = 0;
                while (totalDeleted > 0) {
                    this.deleteFile((String)logFiles[i]);
                    ++i;
                }
                break block3;
            }
            if (!(logFiles instanceof File[])) break block3;
            int i = 0;
            while (totalDeleted > 0) {
                if (((File)logFiles[i]).delete()) {
                    --this.numberFiles;
                }
                ++i;
            }
        }
    }

    private void deleteFile(String filename) {
        File file = new File(this.mainDir, filename);
        if (file.delete()) {
            --this.numberFiles;
        }
    }

    public File findFile(String motif) {
        StringBuilder builder = new StringBuilder(this.beginFP);
        builder.append(motif);
        builder.append(this.endFP);
        File file = new File(this.mainDir, builder.toString());
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public File getMainDirectory() {
        return this.mainDir;
    }

    public String findFileName(String motif) {
        StringBuilder builder = new StringBuilder(this.beginFP);
        builder.append(motif);
        builder.append(this.endFP);
        return builder.toString();
    }

    public int countLogFiles() {
        String[] children = this.mainDir.list(this.filter);
        if (children != null) {
            return children.length;
        }
        return 0;
    }

    public String[] listLogFilenames() {
        Object[] children = this.mainDir.list(this.filter);
        this.updateFileNumber(children);
        int length = children.length;
        if (length > 0) {
            for (int j = 1; j < length; ++j) {
                int i = j - 1;
                if (this.compareFilename((String)children[i], (String)children[j]) <= 0) continue;
                Object str = children[j];
                do {
                    children[i + 1] = children[i];
                } while (--i > -1 && this.compareFilename((String)children[i], (String)str) > 0);
                children[i + 1] = str;
            }
            return children;
        }
        return null;
    }

    public File[] listLogFiles() {
        Object[] array = this.mainDir.listFiles(this.filter);
        this.updateFileNumber(array);
        int length = array.length;
        if (length > 0) {
            for (int j = 1; j < length; ++j) {
                int i = j - 1;
                Object file = array[j];
                String filename = ((File)file).getName();
                if (this.compareFilename(((File)array[i]).getName(), filename) <= 0) continue;
                do {
                    array[i + 1] = array[i];
                } while (--i > -1 && this.compareFilename(((File)array[i]).getName(), filename) > 0);
                array[i + 1] = file;
            }
            return array;
        }
        return null;
    }

    protected void listLogFiles(String filename, LogFileAction action, boolean old, boolean inclusive) {
        block7: {
            int i;
            String[] children = this.listLogFilenames();
            if (children == null) break block7;
            int index = -1;
            int compareResult = 1;
            if (old ^ inclusive) {
                compareResult = 0;
            }
            for (i = 0; i < children.length; ++i) {
                if (this.compareFilename(children[i], filename) < compareResult) continue;
                index = i;
                break;
            }
            if (index != -1) {
                if (old) {
                    for (i = 0; i < index; ++i) {
                        action.execute(children[i]);
                    }
                } else {
                    int length = children.length - index;
                    for (i = 0; i < length; ++i) {
                        action.execute(children[i + index]);
                    }
                }
            }
        }
    }

    protected File[] listLogFiles(String filename, boolean old, boolean inclusive) {
        String[] children = this.listLogFilenames();
        if (children != null) {
            int i;
            File[] result = null;
            int index = -1;
            int compareResult = 1;
            if (old ^ inclusive) {
                compareResult = 0;
            }
            for (i = 0; i < children.length; ++i) {
                if (this.compareFilename(children[i], filename) < compareResult) continue;
                index = i;
                break;
            }
            if (index != -1) {
                if (old) {
                    if (index > 0) {
                        result = new File[index];
                        for (i = 0; i < index; ++i) {
                            result[i] = new File(this.mainDir, children[i]);
                        }
                    }
                } else {
                    int length = children.length - index;
                    if (length > 0) {
                        result = new File[length];
                        for (i = 0; i < length; ++i) {
                            result[i] = new File(this.mainDir, children[i + index]);
                        }
                    }
                }
                return result;
            }
        }
        return null;
    }

    public void cleanLogPool() {
        String[] children;
        for (String child : children = this.mainDir.list(this.filter)) {
            this.deleteFile(child);
        }
    }

    public void cleanLogPool(int nbFiles, boolean old) {
        block5: {
            String[] children;
            if (nbFiles <= 0 || (children = this.listLogFilenames()) == null) break block5;
            int number = nbFiles;
            if (number > children.length) {
                number = children.length;
            }
            if (old) {
                for (int i = 0; i < number; ++i) {
                    this.deleteFile(children[i]);
                }
            } else {
                int end = children.length - number;
                for (int i = children.length - 1; i >= end; --i) {
                    this.deleteFile(children[i]);
                }
            }
        }
    }

    protected void cleanLogPool(String filename, boolean old) {
        block4: {
            String[] children;
            if (filename == null || (children = this.listLogFilenames()) == null) break block4;
            if (old) {
                for (int i = 0; i < children.length && this.compareFilename(children[i], filename) < 0; ++i) {
                    this.deleteFile(children[i]);
                }
            } else {
                for (int i = children.length - 1; i >= 0 && this.compareFilename(children[i], filename) > 0; --i) {
                    this.deleteFile(children[i]);
                }
            }
        }
    }

    protected void removeLogFile(String filename) {
        if (this.filter.accept(this.mainDir, filename)) {
            this.deleteFile(filename);
        }
    }

    public Logger getLogger() {
        String newPattern = this.getLogFilenamePattern();
        if (this.fileLogger && newPattern != null && !newPattern.equals(this.logFilenamePattern)) {
            StringBuilder builder = new StringBuilder(this.beginFP);
            builder.append(newPattern);
            builder.append(this.endFP);
            this.logFilenamePattern = newPattern;
            this.logFilename = builder.toString();
            this.lc.changeHandlerOutput(this.getFileHandlerName(), this.mainPath + this.logFilename);
            this.logger = this.lc.apply();
            if (this.numberFiles >= this.maxFiles) {
                String[] children = this.listLogFilenames();
                new File(this.mainDir, children[0]).delete();
            } else {
                ++this.numberFiles;
            }
        }
        return this.logger;
    }

    public String getPattern(String filename) {
        Matcher m = this.pattern.matcher(filename);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    protected abstract String getLogFilenamePattern();

    protected abstract int compareFilename(String var1, String var2);

    protected String initLogFilenamePattern() throws IOException {
        String initPattern = this.getLogFilenamePattern();
        if (initPattern == null || initPattern.length() == 0) {
            throw new IOException("Initial pattern of the log file name is invalid.");
        }
        return initPattern;
    }

    protected LogConfigurator getLogConfigurator() {
        return this.lc;
    }

    protected String getLoggerLevel() {
        return LOGGER_LEVEL;
    }

    protected String getFileHandlerName() {
        return FILE_HANDLER_NAME;
    }

    protected String getConsoleHandlerName() {
        return CONSOLE_HANDLER_NAME;
    }

    protected FilenameFilter getFilenameFilter() {
        return this.filter;
    }

    protected Pattern getPoolFilePattern() {
        return this.pattern;
    }

    public static interface LogFileAction {
        public void execute(String var1);
    }
}

