/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.component.quartz;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TreeSet;
import org.ow2.easybeans.component.quartz.ScheduleValue;
import org.ow2.easybeans.component.quartz.ValueResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleValueList
extends ScheduleValue {
    private List<ScheduleValue> scheduleValues = new ArrayList<ScheduleValue>();

    public ScheduleValueList(int calendarField) {
        super(calendarField);
    }

    public List<ScheduleValue> getScheduleValues() {
        return this.scheduleValues;
    }

    public void add(ScheduleValue scheduleValue) {
        this.scheduleValues.add(scheduleValue);
    }

    @Override
    public ValueResult getTimeAfter(Calendar afterTimeCalendar) {
        int currentFieldValue = afterTimeCalendar.get(this.getCalendarField());
        TreeSet<Integer> allValuesNoIncrement = new TreeSet<Integer>();
        TreeSet<Integer> allValuesWithIncrement = new TreeSet<Integer>();
        TreeSet<Integer> allValues = new TreeSet<Integer>();
        for (ScheduleValue scheduleValue : this.scheduleValues) {
            ValueResult val = scheduleValue.getTimeAfter(afterTimeCalendar);
            if (val.needsIncrement()) {
                allValuesWithIncrement.add(val.getResult());
            } else {
                allValuesNoIncrement.add(val.getResult());
            }
            allValues.add(val.getResult());
        }
        ValueResult valueResult = new ValueResult();
        Integer foundValue = allValuesNoIncrement.ceiling(currentFieldValue);
        if (foundValue != null) {
            valueResult.setResult(foundValue);
        } else {
            foundValue = allValuesWithIncrement.ceiling(currentFieldValue);
            if (foundValue != null) {
                valueResult.setResult(foundValue);
            }
        }
        if (foundValue == null) {
            valueResult.setResult((Integer)allValues.first());
            valueResult.setNeedsIncrement(true);
        }
        return valueResult;
    }
}

