/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing;

import java.net.URL;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ejb.TransactionAttributeType;
import org.ow2.util.ee.metadata.common.api.xml.struct.IActivationConfig;
import org.ow2.util.ee.metadata.common.api.xml.struct.IAroundInvoke;
import org.ow2.util.ee.metadata.common.api.xml.struct.IEnvironment;
import org.ow2.util.ee.metadata.common.api.xml.struct.IMethodDD;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.CommonDeploymentDescLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.common.impl.xml.struct.ActivationConfig;
import org.ow2.util.ee.metadata.common.impl.xml.struct.AroundInvoke;
import org.ow2.util.ee.metadata.common.impl.xml.struct.MethodDD;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IAssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IEnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.IInterceptors;
import org.ow2.util.ee.metadata.ejbjar.api.xml.struct.ILockType;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JApplicationException;
import org.ow2.util.ee.metadata.ejbjar.impl.struct.JEJBSchedule;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.parsing.EJB3EntityResolver;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AbsBean;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AccessTimeout;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.AssemblyDescriptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.ConcurrentMethod;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.ContainerTransaction;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EJB3;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.EnterpriseBeans;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptor;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.InterceptorBinding;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Interceptors;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDestination;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MessageDriven;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.MethodPermission;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.RemoveMethod;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Session;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.StatefulTimeout;
import org.ow2.util.ee.metadata.ejbjar.impl.xml.struct.Timer;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.xml.DocumentParser;
import org.ow2.util.xml.DocumentParserException;
import org.ow2.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public final class EJB3DeploymentDescLoader
extends CommonDeploymentDescLoader {
    private static Log logger = LogFactory.getLog(EJB3DeploymentDescLoader.class);
    private EJB3 ejb3 = new EJB3();

    private EJB3DeploymentDescLoader(URL url) {
        super(url);
    }

    public static EJB3 loadDeploymentDescriptor(URL url) throws ParsingException {
        logger.debug((Object)"Analyzing url {0}", new Object[]{url});
        EJB3DeploymentDescLoader ejbDeploymentDescLoader = new EJB3DeploymentDescLoader(url);
        ejbDeploymentDescLoader.parse();
        return ejbDeploymentDescLoader.getEJB3();
    }

    public void parse() throws ParsingException {
        NodeList assemblyDescriptorList;
        NodeList interceptorsList;
        Document document = null;
        try {
            document = DocumentParser.getDocument((URL)this.getURL(), (boolean)EJB3DeploymentDescLoader.isValidating(), (EntityResolver)((Object)new EJB3EntityResolver()));
        }
        catch (DocumentParserException e) {
            throw new ParsingException("Cannot parse the url", (Throwable)e);
        }
        Element ejbJarRootElement = document.getDocumentElement();
        this.defineXMLNS(ejbJarRootElement);
        NodeList enterprisebeansList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "enterprise-beans");
        if (enterprisebeansList.getLength() == 1) {
            Element enterpriseBeansElement = (Element)enterprisebeansList.item(0);
            EnterpriseBeans enterpriseBeans = new EnterpriseBeans();
            this.ejb3.setEnterpriseBeans(enterpriseBeans);
            this.analyzeBeans(enterpriseBeansElement, enterpriseBeans);
        }
        if ((interceptorsList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "interceptors")).getLength() == 1) {
            Element interceptorsElement = (Element)interceptorsList.item(0);
            Interceptors interceptors = new Interceptors();
            this.ejb3.setInterceptors(interceptors);
            this.analyzeInterceptorsElement(interceptorsElement, interceptors);
        }
        if ((assemblyDescriptorList = ejbJarRootElement.getElementsByTagNameNS(this.getXMLNS(), "assembly-descriptor")).getLength() == 1) {
            Element assemblyDescriptorElement = (Element)assemblyDescriptorList.item(0);
            AssemblyDescriptor assemblyDescriptor = new AssemblyDescriptor();
            this.ejb3.setAssemblyDescriptor(assemblyDescriptor);
            this.analyzeAssemblyDescriptor(assemblyDescriptorElement, assemblyDescriptor);
        }
        if ("true".equals(ejbJarRootElement.getAttribute("metadata-complete"))) {
            this.ejb3.setMetadataComplete(true);
        } else {
            this.ejb3.setMetadataComplete(false);
        }
    }

    private void analyzeBeans(Element enterpriseBeansElement, IEnterpriseBeans enterpriseBeans) {
        NodeList sessionBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "session");
        for (int i = 0; i < sessionBeansList.getLength(); ++i) {
            Element sessionElement = (Element)sessionBeansList.item(i);
            Session session = new Session();
            enterpriseBeans.addSession(session);
            this.analyzeSessionBean(sessionElement, session);
        }
        NodeList messageDrivenBeansList = enterpriseBeansElement.getElementsByTagNameNS(this.getXMLNS(), "message-driven");
        for (int i = 0; i < messageDrivenBeansList.getLength(); ++i) {
            Element mdbElement = (Element)messageDrivenBeansList.item(i);
            MessageDriven messageDriven = new MessageDriven();
            enterpriseBeans.addMessageDriven(messageDriven);
            this.analyzeMessageDrivenBean(mdbElement, messageDriven);
        }
    }

    private void analyzeBean(Element beanElement, AbsBean bean) {
        String mappedName;
        String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"ejb-name");
        bean.setEjbName(ejbName);
        String ejbClass = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"ejb-class");
        bean.setEjbClass(ejbClass);
        String runAsRole = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"run-as");
        if (runAsRole != null) {
            bean.setRunAsRole(runAsRole);
        }
        if ((mappedName = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"mapped-name")) != null) {
            bean.setMappedName(mappedName);
        }
        String transactionType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"transaction-type");
        bean.setTransactionType(transactionType);
        Element timeoutMethodElement = EJB3DeploymentDescLoader.getChildElementForGivenName(beanElement, "timeout-method");
        if (timeoutMethodElement != null) {
            MethodDD methodDD = this.getMethodFromElement(timeoutMethodElement);
            bean.setTimeoutMethod((IMethodDD)methodDD);
        }
        this.analyzeTimer(beanElement, bean);
        this.analyzeEnvironment(beanElement, bean);
    }

    private void analyzeMessageDrivenBean(Element beanElement, MessageDriven bean) {
        this.analyzeBean(beanElement, bean);
        String messageDestinationType = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"message-destination-type");
        bean.setMessageDestinationType(messageDestinationType);
        String messageDestinationLink = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"message-destination-link");
        bean.setMessageDestinationLink(messageDestinationLink);
        String messagingType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"messaging-type");
        bean.setMessagingType(messagingType);
        NodeList activationConfigList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config");
        for (int i = 0; i < activationConfigList.getLength(); ++i) {
            Element activationConfigElement = (Element)activationConfigList.item(i);
            NodeList activationConfigPropertyList = activationConfigElement.getElementsByTagNameNS(this.getXMLNS(), "activation-config-property");
            for (int j = 0; j < activationConfigPropertyList.getLength(); ++j) {
                Element activationConfigPropertyElement = (Element)activationConfigPropertyList.item(j);
                ActivationConfig activationConfig = new ActivationConfig();
                bean.addActivationConfig((IActivationConfig)activationConfig);
                String name = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)activationConfigPropertyElement, (String)"activation-config-property-name");
                String value = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)activationConfigPropertyElement, (String)"activation-config-property-value");
                activationConfig.setName(name);
                activationConfig.setValue(value);
            }
        }
    }

    private void analyzeSessionBean(Element beanElement, Session bean) {
        this.analyzeBean(beanElement, bean);
        List businessRemoteList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"business-remote");
        for (String businessRemote : businessRemoteList) {
            bean.addBusinessRemote(businessRemote);
        }
        List businessLocalList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"business-local");
        for (String businessLocal : businessLocalList) {
            bean.addBusinessLocal(businessLocal);
        }
        Element statefulTimeoutElement = EJB3DeploymentDescLoader.getChildElementForGivenName(beanElement, "stateful-timeout");
        if (statefulTimeoutElement != null) {
            StatefulTimeout statefulTimeout = new StatefulTimeout();
            String timeoutValueStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)statefulTimeoutElement, (String)"timeout");
            statefulTimeout.setTimeout(Long.valueOf(timeoutValueStr));
            String unitStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)statefulTimeoutElement, (String)"unit");
            statefulTimeout.setUnit(TimeUnit.valueOf(unitStr.toUpperCase()));
            bean.setStatefulTimeout(statefulTimeout);
        }
        NodeList removeMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "remove-method");
        for (int i = 0; i < removeMethodList.getLength(); ++i) {
            Element removeMethodElement = (Element)removeMethodList.item(i);
            RemoveMethod removeMethod = new RemoveMethod();
            bean.addRemoveMethod(removeMethod);
            NodeList beanMethodList = removeMethodElement.getElementsByTagNameNS(this.getXMLNS(), "bean-method");
            removeMethod.setMethod((IMethodDD)this.getMethodFromElement((Element)beanMethodList.item(0)));
            String retainIfExceptionStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)removeMethodElement, (String)"retain-if-exception");
            if (retainIfExceptionStr == null) continue;
            boolean retainIfException = false;
            retainIfException = Boolean.parseBoolean(retainIfExceptionStr);
            removeMethod.setRetainIfException(retainIfException);
        }
        NodeList concurrentMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "concurrent-method");
        for (int i = 0; i < concurrentMethodList.getLength(); ++i) {
            Element concurrentMethodElement = (Element)concurrentMethodList.item(i);
            ConcurrentMethod concurrentMethod = new ConcurrentMethod();
            bean.addConcurrentMethod(concurrentMethod);
            NodeList beanMethodList = concurrentMethodElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            concurrentMethod.setMethod((IMethodDD)this.getMethodFromElement((Element)beanMethodList.item(0)));
            String lockStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)concurrentMethodElement, (String)"lock");
            if (lockStr != null) {
                concurrentMethod.setLockType(ILockType.valueOf(lockStr.toUpperCase()));
            }
            NodeList accessTimeoutList = concurrentMethodElement.getElementsByTagNameNS(this.getXMLNS(), "access-timeout");
            for (int j = 0; j < accessTimeoutList.getLength(); ++j) {
                AccessTimeout accessTimeout = new AccessTimeout();
                concurrentMethod.setAccessTimeout(accessTimeout);
                Element accessTimeoutElement = (Element)accessTimeoutList.item(j);
                String timeoutValueStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)accessTimeoutElement, (String)"timeout");
                accessTimeout.setTimeout(Long.valueOf(timeoutValueStr));
                String unitStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)accessTimeoutElement, (String)"unit");
                accessTimeout.setUnit(TimeUnit.valueOf(unitStr.toUpperCase()));
            }
        }
        NodeList afterBeginMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "after-begin-method");
        for (int i = 0; i < afterBeginMethodList.getLength(); ++i) {
            Element afterBeginMethodElement = (Element)afterBeginMethodList.item(i);
            bean.setAfterBeginMethod((IMethodDD)this.getMethodFromElement(afterBeginMethodElement));
        }
        NodeList beforeCompletionMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "before-completion-method");
        for (int i = 0; i < beforeCompletionMethodList.getLength(); ++i) {
            Element beforeCompletionMethodElement = (Element)beforeCompletionMethodList.item(i);
            bean.setBeforeCompletionMethod((IMethodDD)this.getMethodFromElement(beforeCompletionMethodElement));
        }
        NodeList afterCompletionMethodList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "after-completion-method");
        for (int i = 0; i < afterCompletionMethodList.getLength(); ++i) {
            Element afterCompletionMethodElement = (Element)afterCompletionMethodList.item(i);
            bean.setAfterCompletionMethod((IMethodDD)this.getMethodFromElement(afterCompletionMethodElement));
        }
        String remoteHome = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"home");
        bean.setRemoteHome(remoteHome);
        String localHome = XMLUtils.getChildStringValueForElement((Element)beanElement, (String)"local-home");
        bean.setLocalHome(localHome);
        NodeList localBeanList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "local-bean");
        if (localBeanList != null && localBeanList.getLength() == 1) {
            bean.setLocalBean();
        }
        String sessionType = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)beanElement, (String)"session-type");
        bean.setSessionType(sessionType);
    }

    private MethodDD getMethodFromElement(Element methodElement) {
        MethodDD method = new MethodDD();
        String methodName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)methodElement, (String)"method-name");
        method.setName(methodName);
        String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)methodElement, (String)"ejb-name");
        method.setEjbName(ejbName);
        NodeList methodParamsList = methodElement.getElementsByTagNameNS(this.getXMLNS(), "method-params");
        if (methodParamsList != null && methodParamsList.getLength() == 1) {
            method.initParams();
            Element methodParamsElement = (Element)methodParamsList.item(0);
            List paramList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)methodParamsElement, (String)"method-param");
            for (String param : paramList) {
                method.addParam(param);
            }
        }
        return method;
    }

    public static Element getChildElementForGivenName(Element base, String name) {
        Element foundElement = null;
        NodeList nodeList = base.getChildNodes();
        if (nodeList.getLength() > 0) {
            Node node;
            int length = nodeList.getLength();
            for (int i = 0; !(i >= length || 1 == (node = nodeList.item(i)).getNodeType() && name.equals(node.getNodeName()) && (foundElement = (Element)node) != null); ++i) {
            }
        }
        return foundElement;
    }

    private void analyzeInterceptorsElement(Element interceptorsElement, IInterceptors interceptors) {
        NodeList interceptorList = interceptorsElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            Interceptor interceptor = new Interceptor();
            interceptors.addInterceptor(interceptor);
            String interceptorClass = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorElement, (String)"interceptor-class");
            interceptor.setInterceptorClass(interceptorClass);
            this.analyzeEnvironment(interceptorElement, interceptor);
        }
    }

    private void analyzeAssemblyDescriptor(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        this.analyzeApplicationException(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeInterceptorBinding(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeContainerTransaction(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeSecurity(assemblyDescriptorElement, assemblyDescriptor);
        this.analyzeMessageDestination(assemblyDescriptorElement, assemblyDescriptor);
    }

    private void analyzeInterceptorBinding(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList interceptorBindingList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-binding");
        for (int i = 0; i < interceptorBindingList.getLength(); ++i) {
            String excludeDefaultInterceptorsStr;
            String excludeClassInterceptorsStr;
            NodeList methodList;
            Element interceptorBindingElement = (Element)interceptorBindingList.item(i);
            InterceptorBinding interceptorBinding = new InterceptorBinding();
            assemblyDescriptor.addInterceptorBinding(interceptorBinding);
            String ejbName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"ejb-name");
            interceptorBinding.setEjbName(ejbName);
            NodeList interceptorOrderList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "interceptor-order");
            if (interceptorOrderList != null && interceptorOrderList.getLength() == 1) {
                Element interceptorOrderElement = (Element)interceptorOrderList.item(0);
                List interceptorOrderClassList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)interceptorOrderElement, (String)"interceptor-class");
                for (String interceptorClass : interceptorOrderClassList) {
                    interceptorBinding.addOrderedInterceptorClass(interceptorClass);
                }
            } else {
                List interceptorClassList = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"interceptor-class");
                for (String interceptorClass : interceptorClassList) {
                    interceptorBinding.addInterceptorClass(interceptorClass);
                }
            }
            if ((methodList = interceptorBindingElement.getElementsByTagNameNS(this.getXMLNS(), "method")).getLength() > 0) {
                interceptorBinding.setMethod((IMethodDD)this.getMethodFromElement((Element)methodList.item(0)));
            }
            if ((excludeClassInterceptorsStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"exclude-class-interceptors")) != null) {
                boolean excludeClassInterceptors = false;
                excludeClassInterceptors = Boolean.parseBoolean(excludeClassInterceptorsStr);
                interceptorBinding.setExcludeClassInterceptors(excludeClassInterceptors);
            }
            if ((excludeDefaultInterceptorsStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)interceptorBindingElement, (String)"exclude-default-interceptors")) == null) continue;
            boolean excludeDefaultInterceptors = false;
            excludeDefaultInterceptors = Boolean.parseBoolean(excludeDefaultInterceptorsStr);
            interceptorBinding.setExcludeDefaultInterceptors(excludeDefaultInterceptors);
        }
    }

    private void analyzeApplicationException(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList applicationExceptionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "application-exception");
        for (int i = 0; i < applicationExceptionList.getLength(); ++i) {
            Element applicationExceptionElement = (Element)applicationExceptionList.item(i);
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationExceptionElement, (String)"exception-class");
            String rollbackStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationExceptionElement, (String)"rollback");
            String inheritedStr = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)applicationExceptionElement, (String)"inherited");
            boolean rollback = false;
            if (rollbackStr != null) {
                rollback = Boolean.parseBoolean(rollbackStr);
            }
            boolean inherited = true;
            if (inheritedStr != null) {
                inherited = Boolean.parseBoolean(inheritedStr);
            }
            JApplicationException applicationException = new JApplicationException(className, rollback, inherited);
            assemblyDescriptor.addApplicationException(applicationException);
        }
    }

    private void analyzeContainerTransaction(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList containerTransactionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "container-transaction");
        for (int i = 0; i < containerTransactionList.getLength(); ++i) {
            Element containerTransactionElement = (Element)containerTransactionList.item(i);
            ContainerTransaction containerTransaction = new ContainerTransaction();
            assemblyDescriptor.addContainerTransaction(containerTransaction);
            NodeList methodList = containerTransactionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                containerTransaction.addMethod((IMethodDD)this.getMethodFromElement(methodElement));
            }
            String transactionAttribute = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)containerTransactionElement, (String)"trans-attribute");
            if (transactionAttribute == null) continue;
            if ("NotSupported".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NOT_SUPPORTED);
                continue;
            }
            if ("Supports".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.SUPPORTS);
                continue;
            }
            if ("Required".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRED);
                continue;
            }
            if ("RequiresNew".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.REQUIRES_NEW);
                continue;
            }
            if ("Mandatory".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.MANDATORY);
                continue;
            }
            if ("Never".equals(transactionAttribute)) {
                containerTransaction.setTransactionAttribute(TransactionAttributeType.NEVER);
                continue;
            }
            throw new IllegalStateException("Invalid transaction attribute '" + transactionAttribute + "'");
        }
    }

    private void analyzeSecurity(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList securityRoleList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "security-role");
        for (int i = 0; i < securityRoleList.getLength(); ++i) {
            Element securityRoleElement = (Element)securityRoleList.item(i);
            String securityRole = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)securityRoleElement, (String)"role-name");
            if (securityRole == null) continue;
            assemblyDescriptor.addSecurityRole(securityRole);
        }
        NodeList methodPermissionList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "method-permission");
        for (int i = 0; i < methodPermissionList.getLength(); ++i) {
            Element methodPermissionElement = (Element)methodPermissionList.item(i);
            MethodPermission methodPermission = new MethodPermission();
            assemblyDescriptor.addMethodPermission(methodPermission);
            List roles = XMLUtils.getStringListValueElement((String)this.getXMLNS(), (Element)methodPermissionElement, (String)"role-name");
            for (String roleName : roles) {
                methodPermission.addRoleName(roleName);
            }
            NodeList uncheckedList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "unchecked");
            if (uncheckedList.getLength() > 0) {
                methodPermission.setUnchecked(true);
            }
            NodeList methodList = methodPermissionElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                methodPermission.addMethod((IMethodDD)this.getMethodFromElement(methodElement));
            }
        }
        NodeList excludeList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "exclude-list");
        for (int i = 0; i < excludeList.getLength(); ++i) {
            Element excludeListElement = (Element)excludeList.item(i);
            NodeList methodList = excludeListElement.getElementsByTagNameNS(this.getXMLNS(), "method");
            for (int j = 0; j < methodList.getLength(); ++j) {
                Element methodElement = (Element)methodList.item(j);
                assemblyDescriptor.addExcludeList((IMethodDD)this.getMethodFromElement(methodElement));
            }
        }
    }

    private void analyzeMessageDestination(Element assemblyDescriptorElement, IAssemblyDescriptor assemblyDescriptor) {
        NodeList messageDestinationList = assemblyDescriptorElement.getElementsByTagNameNS(this.getXMLNS(), "message-destination");
        for (int i = 0; i < messageDestinationList.getLength(); ++i) {
            String mappedName;
            Element messageDestinationElement = (Element)messageDestinationList.item(i);
            MessageDestination messageDestination = new MessageDestination();
            String messageDestinationName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationElement, (String)"message-destination-name");
            if (messageDestinationName != null) {
                messageDestination.setName(messageDestinationName);
                assemblyDescriptor.addMessageDestination(messageDestination);
            }
            if ((mappedName = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)messageDestinationElement, (String)"mapped-name")) == null) continue;
            messageDestination.setMappedName(mappedName);
        }
    }

    private void analyzeAroundInvoke(Element envElement, IEnvironment env) {
        NodeList aroundInvokeList = envElement.getElementsByTagNameNS(this.getXMLNS(), "around-invoke");
        for (int i = 0; i < aroundInvokeList.getLength(); ++i) {
            Element aroundInvokeElement = (Element)aroundInvokeList.item(i);
            AroundInvoke aroundInvoke = new AroundInvoke();
            env.addAroundInvoke((IAroundInvoke)aroundInvoke);
            String className = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)aroundInvokeElement, (String)"class");
            aroundInvoke.setClassName(className);
            String method = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)aroundInvokeElement, (String)"method-name");
            aroundInvoke.setMethodName(method);
        }
    }

    protected void analyzeTimer(Element beanElement, AbsBean bean) {
        NodeList timerList = beanElement.getElementsByTagNameNS(this.getXMLNS(), "timer");
        for (int i = 0; i < timerList.getLength(); ++i) {
            String end;
            String start;
            String info;
            String timezone;
            String persistent;
            String year;
            String dayOfWeek;
            String month;
            String dayOfMonth;
            String hour;
            String minute;
            Element timerElement = (Element)timerList.item(i);
            Timer timer = new Timer();
            bean.addTimer(timer);
            JEJBSchedule schedule = new JEJBSchedule();
            timer.setSchedule(schedule);
            NodeList scheduleList = timerElement.getElementsByTagNameNS(this.getXMLNS(), "schedule");
            Element scheduleElement = (Element)scheduleList.item(0);
            String second = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"second");
            if (second != null) {
                schedule.setSecond(second);
            }
            if ((minute = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"minute")) != null) {
                schedule.setMinute(minute);
            }
            if ((hour = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"hour")) != null) {
                schedule.setHour(hour);
            }
            if ((dayOfMonth = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"day-of-month")) != null) {
                schedule.setDayOfMonth(dayOfMonth);
            }
            if ((month = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"month")) != null) {
                schedule.setMonth(month);
            }
            if ((dayOfWeek = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"day-of-week")) != null) {
                schedule.setDayOfWeek(dayOfWeek);
            }
            if ((year = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"year")) != null) {
                schedule.setYear(year);
            }
            if ((persistent = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)timerElement, (String)"persistent")) != null) {
                schedule.setPersistent(Boolean.parseBoolean(persistent));
            }
            if ((timezone = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)timerElement, (String)"timezone")) != null) {
                schedule.setTimezone(timezone);
            }
            if ((info = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)timerElement, (String)"info")) != null) {
                schedule.setInfo(info);
            }
            if ((start = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"start")) != null) {
                schedule.setStart(start);
            }
            if ((end = XMLUtils.getStringValueElement((String)this.getXMLNS(), (Element)scheduleElement, (String)"end")) != null) {
                schedule.setEnd(end);
            }
            NodeList timeoutMethodList = timerElement.getElementsByTagNameNS(this.getXMLNS(), "timeout-method");
            timer.setTimeoutMethod((IMethodDD)this.getMethodFromElement((Element)timeoutMethodList.item(0)));
        }
    }

    protected void analyzeEnvironment(Element envElement, IEnvironment env) {
        this.analyzeLifeCycle(envElement, env, "pre-passivate");
        this.analyzeLifeCycle(envElement, env, "post-activate");
        this.analyzeAroundInvoke(envElement, env);
        super.analyzeEnvironment(envElement, env);
    }

    public EJB3 getEJB3() {
        return this.ejb3;
    }
}

