/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.impl.ProcessorEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed XsltEndpoint")
public class XsltEndpoint
extends ProcessorEndpoint {
    private static final transient Logger LOG = LoggerFactory.getLogger(XsltEndpoint.class);
    private XsltBuilder xslt;
    private String resourceUri;
    private boolean cacheStylesheet;
    private volatile boolean cacheCleared;

    public XsltEndpoint(String endpointUri, Component component, XsltBuilder xslt, String resourceUri, boolean cacheStylesheet) throws Exception {
        super(endpointUri, component, (Processor)xslt);
        this.xslt = xslt;
        this.resourceUri = resourceUri;
        this.cacheStylesheet = cacheStylesheet;
    }

    @ManagedOperation(description="Clears the cached XSLT stylesheet, forcing to re-load the stylesheet on next request")
    public void clearCachedStylesheet() {
        this.cacheCleared = true;
    }

    @ManagedAttribute(description="Whether the XSLT stylesheet is cached")
    public boolean isCacheStylesheet() {
        return this.cacheStylesheet;
    }

    public XsltEndpoint findOrCreateEndpoint(String uri, String newResourceUri) {
        String newUri = uri.replace(this.resourceUri, newResourceUri);
        LOG.trace("Getting endpoint with URI: {}", (Object)newUri);
        return this.getCamelContext().getEndpoint(newUri, XsltEndpoint.class);
    }

    @Override
    protected void onExchange(Exchange exchange) throws Exception {
        String newResourceUri = exchange.getIn().getHeader("CamelXsltResourceUri", String.class);
        if (newResourceUri != null) {
            exchange.getIn().removeHeader("CamelXsltResourceUri");
            LOG.trace("{} set to {} creating new endpoint to handle exchange", (Object)"CamelXsltResourceUri", (Object)newResourceUri);
            XsltEndpoint newEndpoint = this.findOrCreateEndpoint(this.getEndpointUri(), newResourceUri);
            newEndpoint.onExchange(exchange);
            return;
        }
        if (!this.cacheStylesheet || this.cacheCleared) {
            this.loadResource(this.resourceUri);
        }
        super.onExchange(exchange);
    }

    protected void loadResource(String resourceUri) throws TransformerException, IOException {
        LOG.trace("{} loading schema resource: {}", (Object)this, (Object)resourceUri);
        Source source = this.xslt.getUriResolver().resolve(resourceUri, null);
        if (source == null) {
            throw new IOException("Cannot load schema resource " + resourceUri);
        }
        this.xslt.setTransformerSource(source);
        this.cacheCleared = false;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.loadResource(this.resourceUri);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
    }
}

