/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.deployment.ejb;

import org.ow2.jonas.deployment.common.DeploymentDescException;
import org.ow2.jonas.deployment.common.xml.JLinkedList;
import org.ow2.jonas.deployment.ejb.DeploymentDescEjb2;
import org.ow2.jonas.deployment.ejb.EntityCmp2Desc;
import org.ow2.jonas.deployment.ejb.FieldDesc;
import org.ow2.jonas.deployment.ejb.FieldJdbcDesc;
import org.ow2.jonas.deployment.ejb.xml.AssemblyDescriptor;
import org.ow2.jonas.deployment.ejb.xml.CmpFieldJdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.Entity;
import org.ow2.jonas.deployment.ejb.xml.JdbcMapping;
import org.ow2.jonas.deployment.ejb.xml.JonasEntity;

public class EntityJdbcCmp2Desc
extends EntityCmp2Desc {
    protected String dsname;
    protected String jdbcTableName = null;

    public EntityJdbcCmp2Desc(ClassLoader classLoader, Entity ent, AssemblyDescriptor asd, JonasEntity jEnt, DeploymentDescEjb2 dc2d, JLinkedList jMDRList, String fileName) throws DeploymentDescException {
        super(classLoader, ent, asd, jEnt, dc2d, jMDRList, fileName);
        JdbcMapping jm = jEnt.getJdbcMapping();
        if (jm == null) {
            throw new DeploymentDescException("jdbc-mapping missing for bean " + ent.getEjbName());
        }
        this.dsname = jm.getJndiName();
        if (jm.getJdbcTableName() != null && jm.getJdbcTableName().length() != 0) {
            this.jdbcTableName = jm.getJdbcTableName();
        }
        if (this.jdbcTableName == null) {
            this.jdbcTableName = this.getAbstractSchemaName().toUpperCase() + "_";
        }
        for (String fn : this.fieldDesc.keySet()) {
            ((FieldJdbcDesc)this.fieldDesc.get(fn)).setJdbcFieldName(fn + "_");
        }
        for (CmpFieldJdbcMapping fm : jm.getCmpFieldJdbcMappingList()) {
            FieldJdbcDesc fdesc;
            String fn = fm.getFieldName();
            String cn = fm.getJdbcFieldName();
            String ct = null;
            if (fm.getSqlType() != null) {
                ct = fm.getSqlType();
            }
            if ((fdesc = (FieldJdbcDesc)this.fieldDesc.get(fn)) == null) {
                throw new DeploymentDescException("field-name " + fn + " listed in cmp-field-jdbc-mapping is not of cmp-field of bean " + ent.getEjbName());
            }
            fdesc.setJdbcFieldName(cn);
            if (ct == null) continue;
            fdesc.setSqlType(ct);
        }
        if (this.isUndefinedPK() && this.getJdbcAutomaticPkFieldName() != null) {
            ((FieldJdbcDesc)this.fieldDesc.get("JONASAUTOPKFIELD")).setJdbcFieldName(this.getJdbcAutomaticPkFieldName());
        }
    }

    @Override
    protected FieldDesc newFieldDescInstance() {
        return new FieldJdbcDesc();
    }

    public String getDatasourceJndiName() {
        return this.dsname;
    }

    public String getJdbcTableName() {
        return this.jdbcTableName;
    }

    @Override
    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append(super.toString());
        ret.append("\ngetDatasourceJndiName()=" + this.getDatasourceJndiName());
        ret.append("\ngetJdbcTableName()=" + this.getJdbcTableName());
        return ret.toString();
    }
}

