/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.util.Map;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.Session;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.internal.EntityManagerMessageLogger;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SessionOwner;
import org.jboss.logging.Logger;

public class EntityManagerImpl
extends AbstractEntityManagerImpl
implements SessionOwner {
    public static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, EntityManagerImpl.class.getName());
    protected Session session;
    protected boolean open = true;
    protected boolean discardOnClose;
    private Class sessionInterceptorClass;

    public EntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType, boolean discardOnClose, Class sessionInterceptorClass, Map properties) {
        super(entityManagerFactory, pcType, transactionType, properties);
        this.discardOnClose = discardOnClose;
        Object localSessionInterceptor = null;
        if (properties != null) {
            localSessionInterceptor = properties.get("hibernate.ejb.interceptor.session_scoped");
        }
        if (localSessionInterceptor != null) {
            if (localSessionInterceptor instanceof Class) {
                sessionInterceptorClass = localSessionInterceptor;
            } else if (localSessionInterceptor instanceof String) {
                try {
                    sessionInterceptorClass = ReflectHelper.classForName(localSessionInterceptor, EntityManagerImpl.class);
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor, (Throwable)e);
                }
            } else {
                throw new PersistenceException("Unable to instanciate interceptor: " + localSessionInterceptor);
            }
        }
        this.sessionInterceptorClass = sessionInterceptorClass;
        this.postInit();
    }

    @Override
    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        return this.getRawSession();
    }

    @Override
    protected Session getRawSession() {
        if (this.session == null) {
            SessionBuilderImplementor sessionBuilder = this.getEntityManagerFactory().getSessionFactory().withOptions();
            sessionBuilder.owner(this);
            if (this.sessionInterceptorClass != null) {
                try {
                    Interceptor interceptor = (Interceptor)this.sessionInterceptorClass.newInstance();
                    sessionBuilder.interceptor(interceptor);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException("Unable to instanciate session interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
                catch (ClassCastException e) {
                    throw new PersistenceException("Session interceptor does not implement Interceptor: " + this.sessionInterceptorClass, (Throwable)e);
                }
            }
            sessionBuilder.autoJoinTransactions(this.getTransactionType() != PersistenceUnitTransactionType.JTA);
            this.session = sessionBuilder.openSession();
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)((Object)this.session)).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        this.checkEntityManagerFactory();
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if ((this.discardOnClose || !this.isTransactionInProgress()) && this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        this.checkEntityManagerFactory();
        try {
            if (this.open) {
                this.getSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }

    @Override
    public boolean shouldAutoCloseSession() {
        return !this.isOpen();
    }

    private void checkEntityManagerFactory() {
        if (!this.getEntityManagerFactory().isOpen()) {
            this.open = false;
        }
    }
}

