/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.hibernate.ejb.packaging.AbstractJarVisitor;
import org.hibernate.ejb.packaging.ExplodedJarVisitor;
import org.hibernate.ejb.packaging.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EasyBeansExplodedJarVisitor
extends AbstractJarVisitor {
    private static final String WAR_SUFFIX = ".war";
    private static final String CLASS_SUFFIX = ".class";
    private static final String WEB_PREFIX = "WEB-INF/classes";
    private static final int WEb_PREFIX_AFTER_INDEX = "WEB-INF/classes".length();
    private final Logger log = LoggerFactory.getLogger(ExplodedJarVisitor.class);
    private String entry;
    private String path = null;

    public EasyBeansExplodedJarVisitor(URL url, Filter[] filters, String entry) {
        super(url, filters);
        this.entry = entry;
        this.path = url.getPath();
    }

    public EasyBeansExplodedJarVisitor(String fileName, Filter[] filters) {
        super(fileName, filters);
        this.path = fileName;
    }

    private boolean isWar() {
        return this.path.endsWith(WAR_SUFFIX) || this.path.endsWith(WAR_SUFFIX.concat("/"));
    }

    private String treat(String name) {
        if (name.endsWith(CLASS_SUFFIX) && name.startsWith(WEB_PREFIX)) {
            return name.substring(WEb_PREFIX_AFTER_INDEX + 1);
        }
        return name;
    }

    protected void doProcessElements() throws IOException {
        File jarFile;
        try {
            String filePart = this.jarUrl.getFile();
            jarFile = filePart != null && filePart.indexOf(32) != -1 ? new File(this.jarUrl.getFile()) : new File(this.jarUrl.toURI().getSchemeSpecificPart());
        }
        catch (URISyntaxException e) {
            this.log.warn("Malformed url: " + this.jarUrl, (Throwable)e);
            return;
        }
        if (!jarFile.exists()) {
            this.log.warn("Exploded jar does not exists (ignored): {}", (Object)this.jarUrl);
            return;
        }
        if (!jarFile.isDirectory()) {
            this.log.warn("Exploded jar file not a directory (ignored): {}", (Object)this.jarUrl);
            return;
        }
        File rootFile = this.entry != null && this.entry.length() > 0 && !"/".equals(this.entry) ? new File(jarFile, this.entry) : jarFile;
        if (rootFile.isDirectory()) {
            this.getClassNamesInTree(rootFile, null);
        } else {
            this.processZippedRoot(rootFile);
        }
    }

    private void processZippedRoot(File rootFile) throws IOException {
        JarFile jarFile = new JarFile(rootFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (zipEntry.isDirectory()) continue;
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if (this.isWar()) {
                name = this.treat(name);
            }
            this.addElement(name, new BufferedInputStream(jarFile.getInputStream(zipEntry)), new BufferedInputStream(jarFile.getInputStream(zipEntry)));
        }
    }

    private void getClassNamesInTree(File jarFile, String header) throws IOException {
        File[] files = jarFile.listFiles();
        header = header == null ? "" : header + "/";
        for (File localFile : files) {
            if (!localFile.isDirectory()) {
                String entryName = localFile.getName();
                String updatedEntryName = header + entryName;
                if (this.isWar()) {
                    updatedEntryName = this.treat(updatedEntryName);
                }
                this.addElement(updatedEntryName, new BufferedInputStream(new FileInputStream(localFile)), new BufferedInputStream(new FileInputStream(localFile)));
                continue;
            }
            this.getClassNamesInTree(localFile, header + localFile.getName());
        }
    }
}

