/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEmbeddable;
import org.hibernate.internal.jaxb.mapping.orm.JaxbEntity;
import org.hibernate.internal.jaxb.mapping.orm.JaxbMappedSuperclass;
import org.hibernate.internal.jaxb.mapping.orm.JaxbTable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.source.annotations.xml.filter.IndexedAnnotationFilter;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.SchemaAware;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class DefaultConfigurationHelper {
    private static final CoreMessageLogger LOG = Logger.getMessageLogger(CoreMessageLogger.class, DefaultConfigurationHelper.class.getName());
    static final DefaultConfigurationHelper INSTANCE = new DefaultConfigurationHelper();
    static final DotName[] GLOBAL_ANNOTATIONS = new DotName[]{JPADotNames.SEQUENCE_GENERATOR, JPADotNames.TABLE_GENERATOR, JPADotNames.NAMED_QUERIES, JPADotNames.NAMED_QUERY, JPADotNames.NAMED_NATIVE_QUERIES, JPADotNames.NAMED_NATIVE_QUERY, JPADotNames.SQL_RESULT_SET_MAPPING, JPADotNames.SQL_RESULT_SET_MAPPINGS};
    static final DotName[] SCHEMA_AWARE_ANNOTATIONS = new DotName[]{JPADotNames.TABLE, JPADotNames.JOIN_TABLE, JPADotNames.COLLECTION_TABLE, JPADotNames.SECONDARY_TABLE, JPADotNames.SECONDARY_TABLES, JPADotNames.TABLE_GENERATOR, JPADotNames.SEQUENCE_GENERATOR};
    static final DotName[] ASSOCIATION_ANNOTATIONS = new DotName[]{JPADotNames.ONE_TO_MANY, JPADotNames.ONE_TO_ONE, JPADotNames.MANY_TO_ONE, JPADotNames.MANY_TO_MANY};

    private DefaultConfigurationHelper() {
    }

    void applyDefaults(SchemaAware schemaAware, EntityMappingsMocker.Default defaults) {
        if (this.hasSchemaOrCatalogDefined(defaults)) {
            if (StringHelper.isEmpty(schemaAware.getSchema())) {
                schemaAware.setSchema(defaults.getSchema());
            }
            if (StringHelper.isEmpty(schemaAware.getCatalog())) {
                schemaAware.setCatalog(defaults.getCatalog());
            }
        }
    }

    void applyDefaults(Map<DotName, List<AnnotationInstance>> annotationsMap, EntityMappingsMocker.Default defaults) {
        if (annotationsMap.isEmpty() || defaults == null) {
            return;
        }
        if (this.hasSchemaOrCatalogDefined(defaults)) {
            this.applyDefaultSchemaAndCatalog(annotationsMap, defaults);
        }
        if (defaults.isCascadePersist() != null && defaults.isCascadePersist().booleanValue()) {
            this.applyDefaultCascadePersist(annotationsMap);
        }
    }

    void applyDefaults(JaxbMappedSuperclass mappedSuperclass, EntityMappingsMocker.Default defaults) {
        this.applyDefaultsToEntityObject(new MappedSuperClassEntityObject(mappedSuperclass), defaults);
    }

    void applyDefaults(JaxbEmbeddable embeddable, EntityMappingsMocker.Default defaults) {
        this.applyDefaultsToEntityObject(new EmbeddableEntityObject(embeddable), defaults);
    }

    void applyDefaults(JaxbEntity entity, EntityMappingsMocker.Default defaults) {
        this.mockTableIfNonExist(entity, defaults);
        this.applyDefaultsToEntityObject(new EntityEntityObject(entity), defaults);
    }

    private void applyDefaultsToEntityObject(EntityObject entityObject, EntityMappingsMocker.Default defaults) {
        if (defaults == null) {
            return;
        }
        String className = MockHelper.buildSafeClassName(entityObject.getClazz(), defaults.getPackageName());
        entityObject.setClazz(className);
        if (entityObject.isMetadataComplete() == null) {
            entityObject.setMetadataComplete(defaults.isMetadataComplete());
        }
        LOG.debugf("Adding XML overriding information for %s", (Object)className);
    }

    private boolean hasSchemaOrCatalogDefined(EntityMappingsMocker.Default defaults) {
        return defaults != null && (StringHelper.isNotEmpty(defaults.getSchema()) || StringHelper.isNotEmpty(defaults.getCatalog()));
    }

    private void applyDefaultCascadePersist(Map<DotName, List<AnnotationInstance>> annotationsMap) {
        for (DotName annName : ASSOCIATION_ANNOTATIONS) {
            if (!annotationsMap.containsKey(annName)) continue;
            this.addCascadePersistIfNotExist(annName, annotationsMap);
        }
    }

    private void applyDefaultSchemaAndCatalog(Map<DotName, List<AnnotationInstance>> annotationsMap, EntityMappingsMocker.Default defaults) {
        for (DotName annName : SCHEMA_AWARE_ANNOTATIONS) {
            this.mockTableIfNonExist(annotationsMap, annName);
            if (!annotationsMap.containsKey(annName)) continue;
            this.overrideSchemaCatalogByDefault(annName, annotationsMap, defaults);
        }
    }

    private void mockTableIfNonExist(Map<DotName, List<AnnotationInstance>> annotationsMap, DotName annName) {
        if (annName == JPADotNames.TABLE && !annotationsMap.containsKey(JPADotNames.TABLE) && annotationsMap.containsKey(JPADotNames.ENTITY)) {
            AnnotationInstance entity = JandexHelper.getSingleAnnotation(annotationsMap, JPADotNames.ENTITY);
            AnnotationInstance table = MockHelper.create(JPADotNames.TABLE, entity.target(), MockHelper.EMPTY_ANNOTATION_VALUE_ARRAY);
            ArrayList<AnnotationInstance> annotationInstanceList = new ArrayList<AnnotationInstance>(1);
            annotationInstanceList.add(table);
            annotationsMap.put(JPADotNames.TABLE, annotationInstanceList);
        }
    }

    private void mockTableIfNonExist(JaxbEntity entity, EntityMappingsMocker.Default defaults) {
        JaxbTable table;
        if (this.hasSchemaOrCatalogDefined(defaults) && (table = entity.getTable()) == null) {
            table = new JaxbTable();
            entity.setTable(table);
        }
    }

    private void addCascadePersistIfNotExist(DotName annName, Map<DotName, List<AnnotationInstance>> indexedAnnotationMap) {
        List<AnnotationInstance> annotationInstanceList = indexedAnnotationMap.get(annName);
        if (annotationInstanceList == null || annotationInstanceList.isEmpty()) {
            return;
        }
        ArrayList<AnnotationInstance> newAnnotationInstanceList = new ArrayList<AnnotationInstance>(annotationInstanceList.size());
        for (AnnotationInstance annotationInstance : annotationInstanceList) {
            AnnotationValue cascadeValue = annotationInstance.value("cascade");
            ArrayList<AnnotationValue> newAnnotationValueList = new ArrayList<AnnotationValue>();
            newAnnotationValueList.addAll(annotationInstance.values());
            if (cascadeValue == null) {
                AnnotationValue temp = AnnotationValue.createEnumValue((String)"", (DotName)JPADotNames.CASCADE_TYPE, (String)"PERSIST");
                cascadeValue = AnnotationValue.createArrayValue((String)"cascade", (AnnotationValue[])new AnnotationValue[]{temp});
            } else {
                newAnnotationValueList.remove(cascadeValue);
                String[] cascadeTypes = cascadeValue.asEnumArray();
                boolean hasPersistDefined = false;
                for (String type : cascadeTypes) {
                    if (!"PERSIST".equals(type)) continue;
                    hasPersistDefined = true;
                }
                if (hasPersistDefined) {
                    newAnnotationInstanceList.add(annotationInstance);
                    continue;
                }
                String[] newCascadeTypes = new String[cascadeTypes.length + 1];
                newCascadeTypes[0] = "PERSIST";
                System.arraycopy(cascadeTypes, 0, newCascadeTypes, 1, cascadeTypes.length);
                AnnotationValue[] cascades = new AnnotationValue[newCascadeTypes.length];
                for (int i = 0; i < newCascadeTypes.length; ++i) {
                    cascades[i] = AnnotationValue.createEnumValue((String)"", (DotName)JPADotNames.CASCADE_TYPE, (String)newCascadeTypes[i]);
                }
                cascadeValue = AnnotationValue.createArrayValue((String)"cascade", (AnnotationValue[])cascades);
            }
            newAnnotationValueList.add(cascadeValue);
            AnnotationInstance newAnnotationInstance = MockHelper.create(annotationInstance.name(), annotationInstance.target(), MockHelper.toArray(newAnnotationValueList));
            newAnnotationInstanceList.add(newAnnotationInstance);
        }
        indexedAnnotationMap.put(annName, newAnnotationInstanceList);
    }

    private void overrideSchemaCatalogByDefault(DotName annName, Map<DotName, List<AnnotationInstance>> indexedAnnotationMap, EntityMappingsMocker.Default defaults) {
        List<AnnotationInstance> annotationInstanceList = indexedAnnotationMap.get(annName);
        if (annotationInstanceList == null || annotationInstanceList.isEmpty()) {
            return;
        }
        ArrayList<AnnotationInstance> newAnnotationInstanceList = new ArrayList<AnnotationInstance>(annotationInstanceList.size());
        for (AnnotationInstance annotationInstance : annotationInstanceList) {
            if (annName.equals((Object)IndexedAnnotationFilter.SECONDARY_TABLES)) {
                AnnotationInstance[] secondaryTableAnnotationInstanceArray = annotationInstance.value().asNestedArray();
                AnnotationValue[] newAnnotationValueArray = new AnnotationValue[secondaryTableAnnotationInstanceArray.length];
                for (int i = 0; i < secondaryTableAnnotationInstanceArray.length; ++i) {
                    newAnnotationValueArray[i] = MockHelper.nestedAnnotationValue("", this.overrideSchemaCatalogByDefault(secondaryTableAnnotationInstanceArray[i], defaults));
                }
                AnnotationInstance secondaryTablesAnnotationInstance = MockHelper.create(annName, annotationInstance.target(), new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])newAnnotationValueArray)});
                newAnnotationInstanceList.add(secondaryTablesAnnotationInstance);
                continue;
            }
            newAnnotationInstanceList.add(this.overrideSchemaCatalogByDefault(annotationInstance, defaults));
        }
        indexedAnnotationMap.put(annName, newAnnotationInstanceList);
    }

    private AnnotationInstance overrideSchemaCatalogByDefault(AnnotationInstance annotationInstance, EntityMappingsMocker.Default defaults) {
        ArrayList<AnnotationValue> newAnnotationValueList = new ArrayList<AnnotationValue>();
        newAnnotationValueList.addAll(annotationInstance.values());
        boolean schemaDefined = false;
        boolean catalogDefined = false;
        if (annotationInstance.value("schema") != null) {
            schemaDefined = true;
        }
        if (annotationInstance.value("catalog") != null) {
            catalogDefined = true;
        }
        if (schemaDefined && catalogDefined) {
            return annotationInstance;
        }
        if (!catalogDefined && StringHelper.isNotEmpty(defaults.getCatalog())) {
            newAnnotationValueList.add(AnnotationValue.createStringValue((String)"catalog", (String)defaults.getCatalog()));
        }
        if (!schemaDefined && StringHelper.isNotEmpty(defaults.getSchema())) {
            newAnnotationValueList.add(AnnotationValue.createStringValue((String)"schema", (String)defaults.getSchema()));
        }
        return MockHelper.create(annotationInstance.name(), annotationInstance.target(), MockHelper.toArray(newAnnotationValueList));
    }

    private static class MappedSuperClassEntityObject
    implements EntityObject {
        private JaxbMappedSuperclass entity;

        private MappedSuperClassEntityObject(JaxbMappedSuperclass entity) {
            this.entity = entity;
        }

        @Override
        public String getClazz() {
            return this.entity.getClazz();
        }

        @Override
        public void setClazz(String className) {
            this.entity.setClazz(className);
        }

        @Override
        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        @Override
        public void setMetadataComplete(Boolean isMetadataComplete) {
            this.entity.setMetadataComplete(isMetadataComplete);
        }
    }

    private static class EmbeddableEntityObject
    implements EntityObject {
        private JaxbEmbeddable entity;

        private EmbeddableEntityObject(JaxbEmbeddable entity) {
            this.entity = entity;
        }

        @Override
        public String getClazz() {
            return this.entity.getClazz();
        }

        @Override
        public void setClazz(String className) {
            this.entity.setClazz(className);
        }

        @Override
        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        @Override
        public void setMetadataComplete(Boolean isMetadataComplete) {
            this.entity.setMetadataComplete(isMetadataComplete);
        }
    }

    private static class EntityEntityObject
    implements EntityObject {
        private JaxbEntity entity;

        private EntityEntityObject(JaxbEntity entity) {
            this.entity = entity;
        }

        @Override
        public String getClazz() {
            return this.entity.getClazz();
        }

        @Override
        public void setClazz(String className) {
            this.entity.setClazz(className);
        }

        @Override
        public Boolean isMetadataComplete() {
            return this.entity.isMetadataComplete();
        }

        @Override
        public void setMetadataComplete(Boolean isMetadataComplete) {
            this.entity.setMetadataComplete(isMetadataComplete);
        }
    }

    private static interface EntityObject {
        public String getClazz();

        public void setClazz(String var1);

        public Boolean isMetadataComplete();

        public void setMetadataComplete(Boolean var1);
    }
}

