/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.jpa.impl;

import org.hibernate.HibernateException;
import org.hibernate.OptimisticLockException;
import org.hibernate.Session;
import org.hibernate.dialect.lock.OptimisticEntityLockException;

public class OptimisticLockingCompatibilityHelper {
    private static final String parentOptimisticLockExceptionClassName = "org.hibernate.dialect.lock.OptimisticEntityLockException";
    private static final String deprecatedOptimisticLockExceptionClassName = "org.hibernate.OptimisticLockException";
    private static final Class optimisticLockExceptionClass = OptimisticLockingCompatibilityHelper.determineCompatibleOptimisticLockExceptionClass();

    private static Class determineCompatibleOptimisticLockExceptionClass() {
        try {
            return Class.forName(parentOptimisticLockExceptionClassName, true, Session.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(deprecatedOptimisticLockExceptionClassName, true, Session.class.getClassLoader());
            }
            catch (ClassNotFoundException e1) {
                return null;
            }
        }
    }

    private static Object extractEntityOufOfException(HibernateException e) {
        if (parentOptimisticLockExceptionClassName.equals(optimisticLockExceptionClass.getName())) {
            OptimisticEntityLockException oele = (OptimisticEntityLockException)e;
            return oele.getEntity();
        }
        if (deprecatedOptimisticLockExceptionClassName.equals(optimisticLockExceptionClass.getName())) {
            OptimisticLockException oele = (OptimisticLockException)e;
            return oele.getEntity();
        }
        return null;
    }

    public static boolean isOptimisticLockException(HibernateException e) {
        return optimisticLockExceptionClass != null && optimisticLockExceptionClass.isInstance(e);
    }

    public static javax.persistence.OptimisticLockException convertToLockException(HibernateException e) {
        Object entity = OptimisticLockingCompatibilityHelper.extractEntityOufOfException(e);
        if (entity != null) {
            return new javax.persistence.OptimisticLockException(e.getMessage(), (Throwable)e, entity);
        }
        return new javax.persistence.OptimisticLockException(e.getMessage(), (Throwable)e);
    }
}

