/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.common.monitoring;

import fr.dyade.aaa.common.Debug;
import fr.dyade.aaa.common.monitoring.MonitoringTimerTask;
import java.util.Properties;
import java.util.Timer;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class LogMonitoringTimerTask
extends MonitoringTimerTask {
    public static final String MONITORING_CONFIG_PERIOD_PROPERTY = "LOG_MONITORING_CONFIG_PERIOD";
    public static final long DEFAULT_MONITORING_CONFIG_PERIOD = 60000L;
    public static final String MONITORING_CONFIG_PATH_PROPERTY = "LOG_MONITORING_CONFIG_PATH";
    public static final String DEFAULT_MONITORING_CONFIG_PATH = "logMonitoring.props";
    public static final String MONITORING_RESULT_LOGGER_PROPERTY = "LOG_MONITORING_RESULT_LOGGER";
    public static final String DEFAULT_MONITORING_RESULT_LOGGER = "fr.dyade.aaa.Monitoring";
    public static final String MONITORING_RESULT_LEVEL_PROPERTY = "LOG_MONITORING_RESULT_LEVEL";
    public static final int DEFAULT_MONITORING_RESULT_LEVEL = BasicLevel.WARN;
    public static final String MONITORING_RESULT_MESSAGE_PROPERTY = "LOG_MONITORING_RESULT_MESSAGE";
    public static final String DEFAULT_MONITORING_RESULT_MESSAGE = "JMX Monitoring ";
    Logger monitoringLogger;
    String msg;
    int level;
    StringBuffer strbuf = null;

    public LogMonitoringTimerTask(Timer timer, long period, Properties attlist, Logger logger, String msg, int level) {
        super(period, attlist);
        this.monitoringLogger = logger;
        this.msg = msg;
        this.level = level;
        this.strbuf = new StringBuffer();
        this.start(timer);
    }

    public LogMonitoringTimerTask() {
    }

    public void init(Timer timer, long period, Properties attlist, Properties taskProps) {
        this.period = period;
        this.attlist = (Properties)attlist.clone();
        this.monitoringLogger = Debug.getLogger(taskProps.getProperty("logname"));
        this.msg = taskProps.getProperty("msg");
        this.level = this.getLevel(taskProps.getProperty("level"));
        this.strbuf = new StringBuffer();
        this.start(timer);
    }

    protected void initializeRecords() {
        this.strbuf.append(this.msg).append('[');
    }

    protected void addRecord(String mbean, String att, Object value) {
        this.strbuf.append('(').append(mbean).append(':').append(att).append('=').append(value).append(')');
    }

    protected void finalizeRecords() {
        this.strbuf.append(']');
        if (this.monitoringLogger.isLoggable(this.level)) {
            this.monitoringLogger.log(this.level, (Object)this.strbuf.toString());
        }
        this.strbuf.setLength(0);
    }

    protected int getLevel(String levelName) {
        int level = DEFAULT_MONITORING_RESULT_LEVEL;
        try {
            level = Integer.parseInt(levelName);
        }
        catch (Exception e) {
            if (levelName.equals("BasicLevel.DEBUG")) {
                level = BasicLevel.DEBUG;
            }
            if (levelName.equals("BasicLevel.ERROR")) {
                level = BasicLevel.ERROR;
            }
            if (levelName.equals("BasicLevel.FATAL")) {
                level = BasicLevel.FATAL;
            }
            if (levelName.equals("BasicLevel.INFO")) {
                level = BasicLevel.INFO;
            }
            if (levelName.equals("BasicLevel.INHERIT")) {
                level = BasicLevel.INHERIT;
            }
            if (levelName.equals("BasicLevel.WARN")) {
                level = BasicLevel.WARN;
            }
            logger.log(BasicLevel.ERROR, (Object)("LogMonitoringTimerTask getLevel: bad levelName " + levelName));
        }
        return level;
    }
}

